/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.lobby.listener.listeners;

import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import de.murmelmeister.lobby.Main;
import de.murmelmeister.lobby.listener.Listeners;
import de.murmelmeister.lobby.util.config.Configs;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerLevelChangeEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;

public class OtherListener
extends Listeners {
    public OtherListener(Main main) {
        super(main);
    }

    @EventHandler
    public void handleFoodLevelChange(FoodLevelChangeEvent event) {
        if (this.config.getBoolean(Configs.EVENT_PROTECTED_FOOD_LEVEL_CHANGE)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void handlePlayerDropItem(PlayerDropItemEvent event) {
        if (this.config.getBoolean(Configs.EVENT_PROTECTED_PLAYER_DROP_ITEM)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void handlePlayerPickupItem(PlayerPickupItemEvent event) {
        if (this.config.getBoolean(Configs.EVENT_PROTECTED_PLAYER_PICKUP_ITEM)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void handleEntityExplode(EntityExplodeEvent event) {
        if (this.config.getBoolean(Configs.EVENT_PROTECTED_ENTITY_EXPLODE)) {
            event.setCancelled(!(event.getEntity() instanceof Player));
        }
    }

    @EventHandler
    public void handleBlockExplode(BlockExplodeEvent event) {
        if (this.config.getBoolean(Configs.EVENT_PROTECTED_BLOCK_EXPLODE)) {
            event.setCancelled(true);
            event.setYield(0.0f);
        }
    }

    @EventHandler
    public void handlePlayerLevelChange(PlayerLevelChangeEvent event) {
        event.getPlayer().setLevel(this.config.getInt(Configs.EVENT_PROTECTED_PLAYER_CHANGE_LEVEL));
        event.getPlayer().setExp((float)this.config.getDouble(Configs.EVENT_PROTECTED_PLAYER_CHANGE_EXP));
    }

    @EventHandler
    public void handleAttackDamage(EntityDamageByEntityEvent event) {
        if (this.config.getBoolean(Configs.EVENT_PROTECTED_ATTACK_DAMAGE)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void handleFallDamage(EntityDamageEvent event) {
        if (this.config.getBoolean(Configs.EVENT_PROTECTED_FALL_DAMAGE) && event.getEntity() instanceof Player) {
            event.setCancelled(event.getCause().equals((Object)EntityDamageEvent.DamageCause.FALL));
        }
    }

    @EventHandler
    public void handleBlockBreak(BlockBreakEvent event) {
        event.setExpToDrop(0);
        event.setCancelled(!this.listUtil.getBuild().contains(event.getPlayer().getUniqueId()));
    }

    @EventHandler
    public void handleBlockPlace(BlockPlaceEvent event) {
        event.setCancelled(!this.listUtil.getBuild().contains(event.getPlayer().getUniqueId()));
    }

    @EventHandler
    public void handlePlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (this.listUtil.getBuild().contains(player.getUniqueId())) {
            event.setCancelled(false);
            return;
        }
        if ((double)player.getLocation().getBlockY() <= this.locations.getSpawnHeight() && this.locations.isSpawnExist()) {
            player.teleport(this.locations.getSpawn());
        }
    }

    @EventHandler
    public void handlePlayerDeath(PlayerDeathEvent event) {
        event.setDroppedExp(0);
        event.getDrops().clear();
    }

    @EventHandler
    public void handlePlayerInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (this.listUtil.getBuild().contains(player.getUniqueId())) {
            event.setCancelled(!event.getView().getPlayer().equals((Object)player));
        } else {
            event.setCancelled(event.getView().getPlayer().equals((Object)player));
        }
    }

    @EventHandler
    public void handleFarmLandEvent(PlayerJumpEvent event) {
        Player player = event.getPlayer();
        Block block = event.getPlayer().getLocation().getBlock();
        if (block.getType().equals((Object)Material.FARMLAND) || block.getType().equals((Object)Material.WHEAT)) {
            if (player.isJumping()) {
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
            }
        }
    }
}

