/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.lobby.configs;

import de.murmelmeister.lobby.Main;
import de.murmelmeister.lobby.util.FileUtil;
import de.murmelmeister.lobby.util.config.Configs;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.slf4j.Logger;

public class Config {
    private final Logger logger;
    private File file;
    private YamlConfiguration config;

    public Config(Main main) {
        this.logger = main.getLogger();
    }

    public void register() {
        this.create();
        this.load();
        this.save();
    }

    public void create() {
        String fileName = "config.yml";
        this.file = FileUtil.createFile(this.logger, String.format("plugins//%s//", Configs.FILE_NAME.getValue()), fileName);
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void load() {
        for (Configs configs : Configs.values()) {
            if (this.get(configs) != null) continue;
            this.set(configs);
        }
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void set(Configs configs) {
        this.config.set(configs.getPath(), configs.getValue());
    }

    public Object get(Configs configs) {
        return this.config.get(configs.getPath());
    }

    public String getString(Configs configs) {
        return this.config.getString(configs.getPath());
    }

    public boolean getBoolean(Configs configs) {
        return this.config.getBoolean(configs.getPath());
    }

    public int getInt(Configs configs) {
        return this.config.getInt(configs.getPath());
    }

    public double getDouble(Configs configs) {
        return this.config.getDouble(configs.getPath());
    }

    public long getLong(Configs configs) {
        return this.config.getLong(configs.getPath());
    }
}

