/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.lobby.listener.listeners;

import de.murmelmeister.lobby.Main;
import de.murmelmeister.lobby.listener.Listeners;
import de.murmelmeister.lobby.util.HexColor;
import de.murmelmeister.lobby.util.config.Configs;
import de.murmelmeister.lobby.util.config.Messages;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class LobbyItemsListener
extends Listeners {
    public LobbyItemsListener(Main main) {
        super(main);
    }

    @EventHandler
    public void interactItem(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack itemStack = event.getItem();
        if (itemStack == null) {
            return;
        }
        if (!event.getAction().isRightClick()) {
            return;
        }
        if (itemStack.getItemMeta().getDisplayName().equals(HexColor.format(this.config.getString(Configs.LOBBY_ITEMS_NAVIGATOR_DISPLAY_NAME)))) {
            Inventory inventory = player.getServer().createInventory(null, 27, HexColor.format(this.config.getString(Configs.LOBBY_ITEMS_NAVIGATOR_INVENTORY_NAME)));
            inventory.setItem(0, this.createItemDefault());
            inventory.setItem(1, this.createItemDefault());
            inventory.setItem(2, this.createItemDefault());
            inventory.setItem(3, this.createItemDefault());
            inventory.setItem(4, this.createItemDefault());
            inventory.setItem(5, this.createItemDefault());
            inventory.setItem(6, this.createItemDefault());
            inventory.setItem(7, this.createItemDefault());
            inventory.setItem(8, this.createItemDefault());
            inventory.setItem(9, this.createItemDefault());
            inventory.setItem(10, this.createItemDefault());
            inventory.setItem(11, this.createItemCityBuild());
            inventory.setItem(12, this.createItemDefault());
            inventory.setItem(13, this.createItemDefault());
            inventory.setItem(14, this.createItemDefault());
            inventory.setItem(15, this.createItemComingSoon());
            inventory.setItem(16, this.createItemDefault());
            inventory.setItem(17, this.createItemDefault());
            inventory.setItem(18, this.createItemDefault());
            inventory.setItem(19, this.createItemDefault());
            inventory.setItem(20, this.createItemDefault());
            inventory.setItem(21, this.createItemDefault());
            inventory.setItem(22, this.createItemSpawn());
            inventory.setItem(23, this.createItemDefault());
            inventory.setItem(24, this.createItemDefault());
            inventory.setItem(25, this.createItemDefault());
            inventory.setItem(26, this.createItemDefault());
            player.openInventory(inventory);
        }
    }

    @EventHandler
    public void inventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack currentItem = event.getCurrentItem();
        if (currentItem == null) {
            return;
        }
        if (!event.getView().getTitle().equals(HexColor.format(this.config.getString(Configs.LOBBY_ITEMS_NAVIGATOR_INVENTORY_NAME)))) {
            return;
        }
        event.setCancelled(true);
        if (currentItem.equals((Object)this.createItemDefault())) {
            event.setCancelled(true);
        }
        if (currentItem.equals((Object)this.createItemSpawn())) {
            player.closeInventory();
            if (this.locations.isSpawnExist()) {
                player.teleport(this.locations.getSpawn());
            } else {
                this.sendMessage((CommandSender)player, this.message.getString(Messages.EVENT_SPAWN_NOT_EXIST).replace("[PREFIX]", this.message.prefix()));
            }
        }
        if (currentItem.equals((Object)this.createItemComingSoon())) {
            event.setCancelled(true);
        }
        if (currentItem.equals((Object)this.createItemCityBuild())) {
            player.closeInventory();
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(b);
            try {
                out.writeUTF("Connect");
                out.writeUTF(this.config.getString(Configs.EVENT_LOBBY_ITEMS_CITY_BUILD));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.sendMessage((CommandSender)player, this.message.getString(Messages.EVENT_LOBBY_ITEMS_SEND_CITY_BUILD));
            player.sendPluginMessage((Plugin)this.instance, "BungeeCord", b.toByteArray());
        }
    }

    private ItemStack createItemDefault() {
        ItemStack itemStack = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(HexColor.format("&0 "));
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    private ItemStack createItemSpawn() {
        ItemStack itemStack = new ItemStack(Material.MAGMA_CREAM);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(HexColor.format("&8\u00bb #3f00e4Spawn"));
        ArrayList<String> lores = new ArrayList<String>();
        lores.add(HexColor.format("&7Click here to teleport to the spawn."));
        itemMeta.setLore(lores);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    private ItemStack createItemComingSoon() {
        ItemStack itemStack = new ItemStack(Material.BARRIER);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(HexColor.format("&cComing Soon"));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    private ItemStack createItemCityBuild() {
        ItemStack itemStack = new ItemStack(Material.GRASS_BLOCK);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(HexColor.format("&8\u00bb #3f00e4CityBuild &8(&71.21.1&8)"));
        ArrayList<String> lores = new ArrayList<String>();
        lores.add(HexColor.format("&7This is a CityBuild server that is"));
        lores.add(HexColor.format("&7special in the distant future."));
        lores.add(HexColor.format(""));
        lores.add(HexColor.format("&8-> &7Status&8: &aOnline"));
        lores.add(HexColor.format(""));
        lores.add(HexColor.format("&7Click to join the server."));
        itemMeta.setLore(lores);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }
}

