/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.lobby.command.commands;

import de.murmelmeister.lobby.Main;
import de.murmelmeister.lobby.command.CommandManager;
import de.murmelmeister.lobby.util.config.Configs;
import de.murmelmeister.lobby.util.config.Messages;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.GameMode;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildCommand
extends CommandManager {
    public BuildCommand(Main main) {
        super(main);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_BUILD_COMMAND)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_BUILD_COMMAND)) {
            return true;
        }
        if (args.length == 0) {
            if (!this.isEnable(sender, Configs.COMMAND_ENABLE_BUILD_USE)) {
                return true;
            }
            if (!this.hasPermission(sender, Configs.PERMISSION_BUILD_USE)) {
                return true;
            }
            Player player = this.getPlayer(sender);
            if (!this.existPlayer(sender)) {
                return true;
            }
            if (this.listUtil.getBuild().contains(player.getUniqueId())) {
                this.listUtil.getBuild().remove(player.getUniqueId());
                player.setGameMode(GameMode.SURVIVAL);
            } else {
                this.listUtil.getBuild().add(player.getUniqueId());
                player.setGameMode(GameMode.CREATIVE);
            }
        } else if (args.length == 1) {
            if (!this.isEnable(sender, Configs.COMMAND_ENABLE_BUILD_OTHER)) {
                return true;
            }
            if (!this.hasPermission(sender, Configs.PERMISSION_BUILD_OTHER)) {
                return true;
            }
            Player target = sender.getServer().getPlayer(args[0]);
            if (target == null) {
                this.sendMessage(sender, this.message.getString(Messages.NO_PLAYER_EXIST).replace("[PLAYER]", args[0]));
                return true;
            }
            if (this.listUtil.getBuild().contains(target.getUniqueId())) {
                this.listUtil.getBuild().remove(target.getUniqueId());
                target.setGameMode(GameMode.SURVIVAL);
            } else {
                this.listUtil.getBuild().add(target.getUniqueId());
                target.setGameMode(GameMode.CREATIVE);
            }
        } else {
            this.sendMessage(sender, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return new ArrayList<String>();
    }
}

