/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.lobby;

import de.murmelmeister.lobby.Lobby;
import de.murmelmeister.lobby.api.Locations;
import de.murmelmeister.lobby.command.Commands;
import de.murmelmeister.lobby.configs.Config;
import de.murmelmeister.lobby.configs.Message;
import de.murmelmeister.lobby.listener.Listeners;
import de.murmelmeister.lobby.util.ListUtil;
import de.murmelmeister.lobby.util.TablistUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.slf4j.Logger;

public class Main {
    private final Lobby instance;
    private final Logger logger;
    private final ListUtil listUtil;
    private final Config config;
    private final Message message;
    private final Locations locations;
    private final Listeners listeners;
    private final Commands commands;
    private BukkitTask tablistTask;
    private final Map<Player, TablistUtil> playerTablistUtil = new ConcurrentHashMap<Player, TablistUtil>();

    public Main(Lobby instance) {
        this.instance = instance;
        this.logger = instance.getSLF4JLogger();
        this.listUtil = new ListUtil();
        this.config = new Config(this);
        this.message = new Message(this);
        this.locations = new Locations(this);
        this.listeners = new Listeners(this);
        this.commands = new Commands(this);
    }

    public void disable() {
        this.instance.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this.instance);
        if (this.tablistTask != null && !this.tablistTask.isCancelled()) {
            this.tablistTask.cancel();
        }
        this.playerTablistUtil.clear();
    }

    public void enable() {
        this.config.register();
        this.message.register();
        this.locations.create();
        this.listeners.register();
        this.commands.register();
        this.instance.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this.instance, "BungeeCord");
        this.tablistTask = this.instance.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.instance, () -> {
            for (Player player : this.instance.getServer().getOnlinePlayers()) {
                this.playerTablistUtil.computeIfAbsent(player, user -> new TablistUtil(player, this)).setScoreboardTabList();
            }
        }, 0L, 1L);
    }

    public Lobby getInstance() {
        return this.instance;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ListUtil getListUtil() {
        return this.listUtil;
    }

    public Config getConfig() {
        return this.config;
    }

    public Message getMessage() {
        return this.message;
    }

    public Locations getLocations() {
        return this.locations;
    }
}

