/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.utils;

import de.murmelmeister.murmelapi.time.PlayTime;
import de.murmelmeister.murmelapi.time.PlayTimeType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TimeUtil {
    private static final Pattern TIME_PATTERN = Pattern.compile("^(\\d+)([smhdwMy])$");

    public static long formatTime(String args) {
        if (args.equals("-1")) {
            return -1L;
        }
        if (args.startsWith("-")) {
            return -2L;
        }
        Matcher matcher = TIME_PATTERN.matcher(args);
        if (!matcher.matches()) {
            return -3L;
        }
        long duration = Long.parseLong(matcher.group(1));
        String format = matcher.group(2);
        return TimeUtil.getTime(format, duration);
    }

    private static long getTime(String format, long duration) {
        return switch (format) {
            case "s" -> duration * 1000L;
            case "m" -> duration * 1000L * 60L;
            case "h" -> duration * 1000L * 60L * 60L;
            case "d" -> duration * 1000L * 60L * 60L * 24L;
            case "w" -> duration * 1000L * 60L * 60L * 24L * 7L;
            case "M" -> duration * 1000L * 60L * 60L * 24L * 30L;
            case "y" -> duration * 1000L * 60L * 60L * 24L * 365L;
            default -> -3L;
        };
    }

    public static String formatTimeValue(PlayTime playTime, int userId) {
        int currentTime = playTime.getTime(userId);
        if (currentTime == 0) {
            return "0 seconds";
        }
        int years = PlayTimeType.YEARS.fromSeconds(currentTime);
        int days = PlayTimeType.DAYS.fromSeconds(currentTime %= PlayTimeType.YEARS.getMultiplier());
        int hours = PlayTimeType.HOURS.fromSeconds(currentTime %= PlayTimeType.DAYS.getMultiplier());
        int minutes = PlayTimeType.MINUTES.fromSeconds(currentTime %= PlayTimeType.HOURS.getMultiplier());
        int seconds = currentTime % PlayTimeType.MINUTES.getMultiplier();
        return (String)(years != 0 ? TimeUtil.getTimeValue(years, PlayTimeType.YEARS) + " " : "") + (String)(days != 0 ? TimeUtil.getTimeValue(days, PlayTimeType.DAYS) + " " : "") + (String)(hours != 0 ? TimeUtil.getTimeValue(hours, PlayTimeType.HOURS) + " " : "") + (String)(minutes != 0 ? TimeUtil.getTimeValue(minutes, PlayTimeType.MINUTES) + " " : "") + (seconds != 0 ? TimeUtil.getTimeValue(seconds, PlayTimeType.SECONDS) : "").trim();
    }

    public static String formatTimeValue(long durationInMilliseconds) {
        if (durationInMilliseconds <= 0L) {
            return "0 seconds";
        }
        long durationInSeconds = durationInMilliseconds / 1000L;
        long years = durationInSeconds / 31536000L;
        long days = (durationInSeconds %= 31536000L) / 86400L;
        long hours = (durationInSeconds %= 86400L) / 3600L;
        long minutes = (durationInSeconds %= 3600L) / 60L;
        long seconds = durationInSeconds % 60L;
        return (String)(years != 0L ? years + " " + (years == 1L ? "year" : "years") + " " : "") + (String)(days != 0L ? days + " " + (days == 1L ? "day" : "days") + " " : "") + (String)(hours != 0L ? hours + " " + (hours == 1L ? "hour" : "hours") + " " : "") + (String)(minutes != 0L ? minutes + " " + (minutes == 1L ? "minute" : "minutes") + " " : "") + ((String)(seconds != 0L ? seconds + " " + (seconds == 1L ? "second" : "seconds") : "")).trim();
    }

    public static String formatScoreboardTime(PlayTime playTime, int userId) {
        int currentTime = playTime.getTime(userId);
        if (currentTime < 3600) {
            return "0 hours";
        }
        int years = PlayTimeType.YEARS.fromSeconds(currentTime);
        int days = PlayTimeType.DAYS.fromSeconds(currentTime %= PlayTimeType.YEARS.getMultiplier());
        int hours = currentTime % PlayTimeType.DAYS.getMultiplier();
        return (String)(years != 0 ? TimeUtil.getTimeValue(years, PlayTimeType.YEARS) + " " : "") + (String)(days != 0 ? TimeUtil.getTimeValue(days, PlayTimeType.DAYS) + " " : "") + (hours != 0 ? TimeUtil.getTimeValue(hours, PlayTimeType.HOURS) : "").trim();
    }

    private static String getTimeValue(int time, PlayTimeType type) {
        return time == 1 ? "1 " + type.getName().replace("s", "").toLowerCase() : time + " " + type.getName().toLowerCase();
    }
}

