/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.user;

import de.murmelmeister.murmelapi.MurmelAPI;
import de.murmelmeister.murmelapi.database.Database;
import de.murmelmeister.murmelapi.user.User;
import de.murmelmeister.murmelapi.user.parent.UserParent;
import de.murmelmeister.murmelapi.user.parent.UserParentProvider;
import de.murmelmeister.murmelapi.user.permission.UserPermission;
import de.murmelmeister.murmelapi.user.permission.UserPermissionProvider;
import de.murmelmeister.murmelapi.utils.CacheManager;
import de.murmelmeister.murmelapi.utils.MojangUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;

public final class UserProvider
implements User {
    private static final String TABLE_NAME = "Users";
    private final Database database;
    private final CacheManager<String, Integer> usernameCache = new CacheManager();
    private final CacheManager<UUID, Integer> uuidCache = new CacheManager();
    private UserParent parent;
    private UserPermission permission;

    public UserProvider(Database database) {
        this.database = database;
        this.parent = this.getParent();
        this.permission = this.getPermission();
    }

    public static void setup(Database database) {
        database.createTable(TABLE_NAME, "ID INT PRIMARY KEY AUTO_INCREMENT, MojangID UUID UNIQUE, Username VARCHAR(100), FirstJoinTime DATETIME");
        Procedure.loadAll(database);
        UserProvider.createConsoleUser(database);
    }

    private static void createConsoleUser(Database database) {
        int id = -1;
        if (database.existsCallable(Procedure.GET_DATA_BY_ID.getName(), id)) {
            return;
        }
        database.updateCallable(Procedure.CREATE_CONSOLE.getName(), id);
    }

    @Override
    public int createOrGetUser(String username) {
        if (username == null) {
            return -2;
        }
        int userId = this.getId(username);
        if (userId != -2) {
            return userId;
        }
        try {
            UUID uuid = MojangUtils.getUUID(username);
            this.createUser(uuid, username);
        }
        catch (IOException | URISyntaxException e) {
            throw new CompletionException(e);
        }
        return this.getId(username);
    }

    @Override
    public CompletableFuture<Integer> createOrGetUserAsync(UUID uuid) {
        if (uuid == null) {
            return CompletableFuture.completedFuture(-2);
        }
        return CompletableFuture.supplyAsync(() -> this.createOrGetUser(uuid));
    }

    @Override
    public int createOrGetUser(UUID uuid) {
        if (uuid == null) {
            return -2;
        }
        int userId = this.getId(uuid);
        if (userId != -2) {
            return userId;
        }
        try {
            String username = MojangUtils.getUsername(uuid);
            this.createUser(uuid, username);
        }
        catch (IOException | URISyntaxException e) {
            throw new CompletionException(e);
        }
        return this.getId(uuid);
    }

    @Override
    public CompletableFuture<Integer> createOrGetUserAsync(String username) {
        if (username == null) {
            return CompletableFuture.completedFuture(-2);
        }
        return CompletableFuture.supplyAsync(() -> this.createOrGetUser(username));
    }

    @Override
    public boolean existsUser(UUID uuid) {
        return uuid != null && this.database.existsCallable(Procedure.GET_ID_BY_UUID.getName(), uuid.toString());
    }

    @Override
    public CompletableFuture<Boolean> existsUserAsync(UUID uuid) {
        return uuid == null ? CompletableFuture.completedFuture(false) : this.database.existsCallableAsync(Procedure.GET_ID_BY_UUID.getName(), uuid.toString());
    }

    @Override
    public boolean existsUser(String username) {
        return username != null && this.database.existsCallable(Procedure.GET_ID_BY_USERNAME.getName(), username);
    }

    @Override
    public CompletableFuture<Boolean> existsUserAsync(String username) {
        return username == null ? CompletableFuture.completedFuture(false) : this.database.existsCallableAsync(Procedure.GET_ID_BY_USERNAME.getName(), username);
    }

    @Override
    public void createUser(UUID uuid, String username) {
        Objects.requireNonNull(uuid, "uuid cannot be null");
        Objects.requireNonNull(username, "username cannot be null");
        this.database.updateCallable(Procedure.CREATE.getName(), uuid.toString(), username);
    }

    @Override
    public CompletableFuture<Integer> createUserAsync(UUID uuid, String username) {
        Objects.requireNonNull(uuid, "uuid cannot be null");
        Objects.requireNonNull(username, "username cannot be null");
        return this.database.updateCallableAsync(Procedure.CREATE.getName(), uuid.toString(), username);
    }

    @Override
    public void deleteUser(UUID uuid) {
        Objects.requireNonNull(uuid, "uuid cannot be null");
        String username = this.getUsername(uuid);
        this.database.updateCallable(Procedure.DELETE.getName(), uuid.toString());
        if (username != null) {
            this.usernameCache.remove(username);
        }
        if (this.uuidCache.get(uuid) != null) {
            this.uuidCache.remove(uuid);
        }
    }

    @Override
    public CompletableFuture<Integer> deleteUserAsync(UUID uuid) {
        Objects.requireNonNull(uuid, "uuid cannot be null");
        return this.database.updateCallableAsync(Procedure.DELETE.getName(), uuid.toString()).thenApply(result -> {
            String username = this.getUsername(uuid);
            if (username != null) {
                this.usernameCache.remove(username);
            }
            if (this.uuidCache.get(uuid) != null) {
                this.uuidCache.remove(uuid);
            }
            return result;
        });
    }

    @Override
    public int getId(UUID uuid) {
        if (uuid == null) {
            return -2;
        }
        Integer cached = this.uuidCache.get(uuid);
        return cached != null ? cached.intValue() : this.database.queryCallable(Procedure.GET_ID_BY_UUID.getName(), -2, resultSet -> {
            int id = resultSet.getInt("ID");
            if (id != -2) {
                this.uuidCache.put(uuid, id, 1L, TimeUnit.HOURS);
            }
            return id;
        }, uuid.toString()).intValue();
    }

    @Override
    public CompletableFuture<Integer> getIdAsync(UUID uuid) {
        if (uuid == null) {
            return CompletableFuture.completedFuture(-2);
        }
        return this.database.queryCallableAsync(Procedure.GET_ID_BY_UUID.getName(), -2, resultSet -> {
            int id = resultSet.getInt("ID");
            if (id != -2) {
                this.uuidCache.put(uuid, id, 1L, TimeUnit.HOURS);
            }
            return id;
        }, uuid.toString());
    }

    @Override
    public int getId(String username) {
        if (username == null) {
            return -2;
        }
        Integer cached = this.usernameCache.get(username);
        return cached != null ? cached.intValue() : this.database.queryCallable(Procedure.GET_ID_BY_USERNAME.getName(), -2, resultSet -> {
            int id = resultSet.getInt("ID");
            if (id != -2) {
                this.usernameCache.put(username, id, 1L, TimeUnit.HOURS);
            }
            return id;
        }, username).intValue();
    }

    @Override
    public CompletableFuture<Integer> getIdAsync(String username) {
        if (username == null) {
            return CompletableFuture.completedFuture(-2);
        }
        return this.database.queryCallableAsync(Procedure.GET_ID_BY_USERNAME.getName(), -2, resultSet -> {
            int id = resultSet.getInt("ID");
            if (id != -2) {
                this.usernameCache.put(username, id, 1L, TimeUnit.HOURS);
            }
            return id;
        }, username);
    }

    @Override
    public UUID getUniqueId(int userId) {
        return this.database.queryCallable(Procedure.GET_DATA_BY_ID.getName(), null, resultSet -> {
            String id = resultSet.getString("MojangID");
            return id == null ? null : UUID.fromString(id);
        }, userId);
    }

    @Override
    public CompletableFuture<UUID> getUniqueIdAsync(int userId) {
        return this.database.queryCallableAsync(Procedure.GET_DATA_BY_ID.getName(), null, resultSet -> {
            String id = resultSet.getString("MojangID");
            return id == null ? null : UUID.fromString(id);
        }, userId);
    }

    @Override
    public UUID getUniqueId(String username) {
        if (username == null) {
            return null;
        }
        int userId = this.getId(username);
        if (userId == -2) {
            return null;
        }
        return this.database.queryCallable(Procedure.GET_DATA_BY_ID.getName(), null, resultSet -> {
            String mojangId = resultSet.getString("MojangID");
            return mojangId == null ? null : UUID.fromString(mojangId);
        }, userId);
    }

    @Override
    public CompletableFuture<UUID> getUniqueIdAsync(String username) {
        if (username == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.database.queryCallableAsync(Procedure.GET_DATA_BY_ID.getName(), null, resultSet -> {
            String mojangId = resultSet.getString("MojangID");
            return mojangId == null ? null : UUID.fromString(mojangId);
        }, this.getId(username));
    }

    @Override
    public String getUsername(int userId) {
        return userId == -1 ? "CONSOLE" : this.database.queryCallable(Procedure.GET_DATA_BY_ID.getName(), null, resultSet -> resultSet.getString("Username"), userId);
    }

    @Override
    public CompletableFuture<String> getUsernameAsync(int userId) {
        return this.database.queryCallableAsync(Procedure.GET_DATA_BY_ID.getName(), null, resultSet -> resultSet.getString("Username"), userId).thenApply(username -> {
            if (userId == -1) {
                return "CONSOLE";
            }
            return username;
        });
    }

    @Override
    public String getUsername(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        int userId = this.getId(uuid);
        if (userId == -2) {
            return null;
        }
        return this.database.queryCallable(Procedure.GET_DATA_BY_ID.getName(), null, resultSet -> resultSet.getString("Username"), userId);
    }

    @Override
    public CompletableFuture<String> getUsernameAsync(UUID uuid) {
        if (uuid == null) {
            return CompletableFuture.completedFuture(null);
        }
        int userId = this.getId(uuid);
        if (userId == -2) {
            return CompletableFuture.completedFuture(null);
        }
        return this.database.queryCallableAsync(Procedure.GET_DATA_BY_ID.getName(), null, resultSet -> resultSet.getString("Username"), userId);
    }

    @Override
    public void rename(int userId, String newUsername) {
        if (userId == -1 || userId == -2 || newUsername == null) {
            return;
        }
        this.database.updateCallable(Procedure.RENAME.getName(), userId, newUsername);
    }

    @Override
    public CompletableFuture<Integer> renameAsync(int userId, String newUsername) {
        if (userId == -1 || userId == -2 || newUsername == null) {
            return CompletableFuture.completedFuture(-2);
        }
        return this.database.updateCallableAsync(Procedure.RENAME.getName(), userId, newUsername);
    }

    @Override
    public void rename(UUID uuid, String newUsername) {
        if (uuid == null || newUsername == null) {
            return;
        }
        int userId = this.getId(uuid);
        if (userId == -2) {
            return;
        }
        this.database.updateCallable(Procedure.RENAME.getName(), userId, newUsername);
    }

    @Override
    public CompletableFuture<Integer> renameAsync(UUID uuid, String newUsername) {
        if (uuid == null || newUsername == null) {
            return CompletableFuture.completedFuture(-2);
        }
        int userId = this.getId(uuid);
        if (userId == -2) {
            return CompletableFuture.completedFuture(-2);
        }
        return this.database.updateCallableAsync(Procedure.RENAME.getName(), userId, newUsername);
    }

    @Override
    public List<UUID> getUniqueIds() {
        return this.database.queryListCallable(Procedure.GET_DATA.getName(), new LinkedList(), resultSet -> {
            String id = resultSet.getString("MojangID");
            return id == null ? null : UUID.fromString(id);
        }, new Object[0]).stream().filter(Objects::nonNull).toList();
    }

    @Override
    public CompletableFuture<List<UUID>> getUniqueIdsAsync() {
        return this.database.queryListCallableAsync(Procedure.GET_DATA.getName(), new LinkedList(), resultSet -> {
            String id = resultSet.getString("MojangID");
            return id == null ? null : UUID.fromString(id);
        }, new Object[0]).thenApply(list -> list.stream().filter(Objects::nonNull).toList());
    }

    @Override
    public List<String> getUsernames() {
        return this.database.queryListCallable(Procedure.GET_DATA.getName(), new LinkedList(), resultSet -> resultSet.getString("Username"), new Object[0]).stream().filter(Objects::nonNull).toList();
    }

    @Override
    public CompletableFuture<List<String>> getUsernamesAsync() {
        return this.database.queryListCallableAsync(Procedure.GET_DATA.getName(), new LinkedList(), resultSet -> resultSet.getString("Username"), new Object[0]).thenApply(list -> list.stream().filter(Objects::nonNull).toList());
    }

    @Override
    public Timestamp getFirstJoinTime(int userId) {
        return this.database.queryCallable(Procedure.GET_DATA_BY_ID.getName(), null, resultSet -> resultSet.getTimestamp("FirstJoinTime"), userId);
    }

    @Override
    public CompletableFuture<Timestamp> getFirstJoinTimeAsync(int userId) {
        return this.database.queryCallableAsync(Procedure.GET_DATA_BY_ID.getName(), null, resultSet -> resultSet.getTimestamp("FirstJoinTime"), userId);
    }

    @Override
    public String getFirstJoinDate(int userId) {
        return this.database.queryCallable(Procedure.GET_DATA_BY_ID.getName(), null, resultSet -> {
            Timestamp time = resultSet.getTimestamp("FirstJoinTime");
            return time == null ? "never" : MurmelAPI.getDateFormat().format(time);
        }, userId);
    }

    @Override
    public CompletableFuture<String> getFirstJoinDateAsync(int userId) {
        return this.database.queryCallableAsync(Procedure.GET_DATA_BY_ID.getName(), null, resultSet -> {
            Timestamp time = resultSet.getTimestamp("FirstJoinTime");
            return time == null ? "never" : MurmelAPI.getDateFormat().format(time);
        }, userId);
    }

    @Override
    public void setFirstJoinTime(int userId) {
        if (userId == -2 || userId == -1) {
            return;
        }
        this.database.updateCallable(Procedure.SET_FIRST_JOIN.getName(), userId, new Timestamp(System.currentTimeMillis()).toString());
    }

    @Override
    public CompletableFuture<Integer> setFirstJoinTimeAsync(int userId) {
        if (userId == -2 || userId == -1) {
            return CompletableFuture.completedFuture(-2);
        }
        return this.database.updateCallableAsync(Procedure.SET_FIRST_JOIN.getName(), userId, new Timestamp(System.currentTimeMillis()).toString());
    }

    @Override
    public void joinUser(UUID uuid, String username) {
        if (uuid == null || username == null) {
            return;
        }
        int userId = this.getId(uuid);
        if (userId == -1) {
            return;
        }
        if (userId == -2) {
            this.createUser(uuid, username);
            return;
        }
        String currentUsername = this.getUsername(userId);
        if (currentUsername == null) {
            this.rename(userId, username);
            return;
        }
        if (!currentUsername.equals(username)) {
            this.rename(userId, username);
        }
    }

    @Override
    public CompletableFuture<Void> joinUserAsync(UUID uuid, String username) {
        return CompletableFuture.runAsync(() -> this.joinUser(uuid, username));
    }

    @Override
    public void loadExpired() {
        this.parent.loadExpired();
        this.permission.loadExpired();
    }

    @Override
    public UserParent getParent() {
        if (this.parent == null) {
            this.parent = new UserParentProvider(this.database);
        }
        return this.parent;
    }

    @Override
    public UserPermission getPermission() {
        if (this.permission == null) {
            this.permission = new UserPermissionProvider(this.database);
        }
        return this.permission;
    }

    private static enum Procedure {
        GET_DATA_BY_ID("Users_GetDataById", "uid INT", "SELECT MojangID, Username, FirstJoinTime FROM [TABLE] WHERE ID=uid;"),
        GET_ID_BY_UUID("Users_GetIdByUUID", "uid UUID", "SELECT ID FROM [TABLE] WHERE MojangID=uid;"),
        GET_ID_BY_USERNAME("Users_GetIdByUsername", "uname VARCHAR(100)", "SELECT ID FROM [TABLE] WHERE Username=uname;"),
        GET_DATA("Users_GetData", "", "SELECT ID, MojangID, Username FROM [TABLE];"),
        CREATE("Users_Create", "uid UUID, uname VARCHAR(100)", "INSERT INTO [TABLE] (MojangID,Username) VALUES (uid,uname);"),
        DELETE("Users_Delete", "uid UUID", "DELETE FROM [TABLE] WHERE MojangID=uid;"),
        RENAME("Users_Rename", "uid INT, uname VARCHAR(100)", "UPDATE [TABLE] SET Username=uname WHERE ID=uid;"),
        SET_FIRST_JOIN("Users_SetFirstJoin", "uid INT, time DATETIME", "UPDATE [TABLE] SET FirstJoinTime=time WHERE ID=uid;"),
        CREATE_CONSOLE("Users_CreateConsole", "uid INT", "INSERT INTO [TABLE] (ID) VALUES (uid);");

        private static final Procedure[] VALUES;
        private final String name;
        private final String query;

        private Procedure(String name, String input, String query) {
            this.name = name;
            this.query = Database.getProcedureQuery(name, input, query);
        }

        public String getName() {
            return this.name;
        }

        public String getQuery() {
            return this.query.replace("[TABLE]", UserProvider.TABLE_NAME);
        }

        private static void loadAll(Database database) {
            for (Procedure procedure : VALUES) {
                database.update(procedure.getQuery(), new Object[0]);
            }
        }

        static {
            VALUES = Procedure.values();
        }
    }
}

