/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.punishment;

import de.murmelmeister.murmelapi.database.Database;
import de.murmelmeister.murmelapi.punishment.PunishmentUser;
import de.murmelmeister.murmelapi.punishment.log.PunishmentLog;
import de.murmelmeister.murmelapi.punishment.reason.PunishmentReason;
import java.net.InetAddress;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public final class PunishmentUserProvider
implements PunishmentUser {
    private static final String TABLE_NAME = "PunishmentUsers";
    private final Database database;
    private final PunishmentReason reason;
    private final PunishmentLog log;

    public PunishmentUserProvider(Database database, PunishmentReason reason, PunishmentLog log) {
        this.database = database;
        this.reason = reason;
        this.log = log;
    }

    public static void setup(Database database) {
        database.createTable(TABLE_NAME, "UserID INT, TypeID INT, PRIMARY KEY (UserID, TypeID), FOREIGN KEY (UserID) REFERENCES Users(ID), FOREIGN KEY (TypeID) REFERENCES PunishmentTypes(ID), LogID UUID, FOREIGN KEY (LogID) REFERENCES PunishmentLog(LogID)");
        Procedure.loadAll(database);
    }

    @Override
    public boolean exists(int userId, int typeId) {
        return this.database.existsCallable(Procedure.GET_BY_ID.getName(), userId, typeId);
    }

    @Override
    public void punish(int userId, int typeId, int executorId, InetAddress inetAddress, int reasonId) {
        UUID logId = this.log.addLogUser(executorId, typeId, userId, inetAddress, reasonId);
        this.database.updateCallable(Procedure.CREATE.getName(), userId, typeId, logId.toString());
    }

    @Override
    public void unpunished(int userId, int typeId) {
        this.database.updateCallable(Procedure.DELETE.getName(), userId, typeId);
    }

    @Override
    public List<Integer> getUsers(int typeId) {
        return this.database.queryListCallable(Procedure.GET_ALL.getName(), new LinkedList(), resultSet -> resultSet.getInt("UserID"), typeId);
    }

    @Override
    public UUID getLogId(int userId, int typeId) {
        String id = this.database.queryCallable(Procedure.GET_BY_ID.getName(), null, resultSet -> resultSet.getString("LogID"), userId, typeId);
        return id != null ? UUID.fromString(id) : null;
    }

    @Override
    public int getReasonId(int userId, int typeId) {
        UUID logId = this.getLogId(userId, typeId);
        return logId != null ? this.log.getReasonId(logId, typeId) : -1;
    }

    @Override
    public void setReasonId(int userId, int typeId, int executorId, int reasonId) {
        UUID logId = this.getLogId(userId, typeId);
        this.log.setReasonId(logId, typeId, executorId, reasonId);
    }

    @Override
    public String getReason(int userId, int typeId) {
        int reasonId = this.getReasonId(userId, typeId);
        return this.reason.getReason(reasonId, typeId);
    }

    @Override
    public long getDuration(int userId, int typeId) {
        int reasonId = this.getReasonId(userId, typeId);
        return this.reason.getDuration(reasonId, typeId);
    }

    @Override
    public Timestamp getExpiredAt(int userId, int typeId) {
        UUID logId = this.getLogId(userId, typeId);
        return logId != null ? this.log.getExpiredAt(logId, typeId) : null;
    }

    @Override
    public void setExpiredAt(int userId, int typeId, int executorId, long time) {
        UUID logId = this.getLogId(userId, typeId);
        this.log.setExpiredAt(logId, typeId, executorId, time);
    }

    @Override
    public boolean isPunished(int userId, int typeId) {
        UUID logId = this.getLogId(userId, typeId);
        return logId != null && !this.log.isExpired(logId, typeId);
    }

    @Override
    public int getCreatedBy(int userId, int typeId) {
        UUID logId = this.getLogId(userId, typeId);
        return logId != null ? this.log.getCreatedBy(logId, typeId) : -2;
    }

    @Override
    public Timestamp getCreatedAt(int userId, int typeId) {
        UUID logId = this.getLogId(userId, typeId);
        return logId != null ? this.log.getCreatedAt(logId, typeId) : null;
    }

    @Override
    public int getModifiedBy(int userId, int typeId) {
        UUID logId = this.getLogId(userId, typeId);
        return logId != null ? this.log.getModifiedBy(logId, typeId) : -2;
    }

    @Override
    public Timestamp getModifiedAt(int userId, int typeId) {
        UUID logId = this.getLogId(userId, typeId);
        return logId != null ? this.log.getModifiedAt(logId, typeId) : null;
    }

    private static enum Procedure {
        GET_BY_ID("PunishmentUser_GetById", "uid INT, tid INT", "SELECT * FROM [TABLE] WHERE UserID=uid AND TypeID=tid;"),
        GET_ALL("PunishmentUser_GetAll", "tid INT", "SELECT * FROM [TABLE] WHERE TypeID=tid;"),
        CREATE("PunishmentUser_Create", "uid INT, tid INT, lid UUID", "INSERT INTO [TABLE] VALUES (uid,tid,lid);"),
        DELETE("PunishmentUser_Delete", "uid INT, tid INT", "DELETE FROM [TABLE] WHERE UserID=uid AND TypeID=tid;");

        private static final Procedure[] VALUES;
        private final String name;
        private final String query;

        private Procedure(String name, String input, String query) {
            this.name = name;
            this.query = Database.getProcedureQuery(name, input, query);
        }

        public String getName() {
            return this.name;
        }

        public String getQuery() {
            return this.query.replace("[TABLE]", PunishmentUserProvider.TABLE_NAME);
        }

        private static void loadAll(Database database) {
            for (Procedure procedure : VALUES) {
                database.update(procedure.getQuery(), new Object[0]);
            }
        }

        static {
            VALUES = Procedure.values();
        }
    }
}

