/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.punishment;

import de.murmelmeister.murmelapi.MurmelAPI;
import de.murmelmeister.murmelapi.database.Database;

public enum PunishmentType {
    BAN(1, "Ban", false),
    MUTE(2, "Mute", false),
    IP_BAN(3, "IP-Ban", true),
    IP_MUTE(4, "IP-Mute", true);

    public static final PunishmentType[] VALUES;
    private static final String TABLE_NAME = "PunishmentTypes";
    private static final Database DATABASE;
    private final int id;
    private final String name;
    private final boolean typeIp;

    private PunishmentType(int id, String name, boolean typeIp) {
        this.id = id;
        this.name = name;
        this.typeIp = typeIp;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTypeIp() {
        return this.typeIp;
    }

    public static PunishmentType fromString(String value) {
        for (PunishmentType type : VALUES) {
            if (!type.name().equals(value)) continue;
            return type;
        }
        return null;
    }

    public static boolean exists(PunishmentType type) {
        return DATABASE.existsCallable(Procedure.GET_TYPE.getName(), type.getId());
    }

    public static void setup(Database database) {
        database.createTable(TABLE_NAME, "ID INT PRIMARY KEY, TypeName TEXT, TypeIP BOOL");
        Procedure.loadAll(database);
        for (PunishmentType type : VALUES) {
            if (PunishmentType.exists(type)) continue;
            database.updateCallable(Procedure.CREATE_TYPE.getName(), type.getId(), type.getName(), type.isTypeIp());
        }
    }

    static {
        VALUES = PunishmentType.values();
        DATABASE = MurmelAPI.getDatabase();
    }

    private static enum Procedure {
        CREATE_TYPE("PunishmentTypes_Create", "tid INT, tn TEXT, tip BOOL", "INSERT INTO [TABLE] VALUES (tid,tn,tip);"),
        GET_TYPE("PunishmentTypes_Get", "tid INT", "SELECT ID FROM [TABLE] WHERE ID=tid;");

        private static final Procedure[] VALUES;
        private final String name;
        private final String query;

        private Procedure(String name, String input, String query) {
            this.name = name;
            this.query = Database.getProcedureQuery(name, input, query);
        }

        public String getName() {
            return this.name;
        }

        public String getQuery() {
            return this.query.replace("[TABLE]", PunishmentType.TABLE_NAME);
        }

        private static void loadAll(Database database) {
            for (Procedure procedure : VALUES) {
                database.update(procedure.getQuery(), new Object[0]);
            }
        }

        static {
            VALUES = Procedure.values();
        }
    }
}

