/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.punishment;

import de.murmelmeister.murmelapi.database.Database;
import de.murmelmeister.murmelapi.punishment.PunishmentIP;
import de.murmelmeister.murmelapi.punishment.log.PunishmentLog;
import de.murmelmeister.murmelapi.punishment.reason.PunishmentReason;
import java.net.InetAddress;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public final class PunishmentIPProvider
implements PunishmentIP {
    private static final String TABLE_NAME = "PunishmentIPs";
    private final Database database;
    private final PunishmentReason reason;
    private final PunishmentLog log;

    public PunishmentIPProvider(Database database, PunishmentReason reason, PunishmentLog log) {
        this.database = database;
        this.reason = reason;
        this.log = log;
    }

    public static void setup(Database database) {
        database.createTable(TABLE_NAME, "IPAddress INET6, TypeID INT, PRIMARY KEY (IPAddress, TypeID), FOREIGN KEY (TypeID) REFERENCES PunishmentTypes(ID), LogID UUID, FOREIGN KEY (LogID) REFERENCES PunishmentLog(LogID)");
        Procedure.loadAll(database);
    }

    @Override
    public boolean exists(InetAddress inetAddress, int typeId) {
        return this.database.existsCallable(Procedure.GET_BY_ID.getName(), inetAddress.getHostAddress(), typeId);
    }

    @Override
    public void punish(InetAddress inetAddress, int typeId, int executorId, int reasonId) {
        UUID logId = this.log.addLogIp(executorId, typeId, inetAddress, reasonId);
        this.database.updateCallable(Procedure.CREATE.getName(), inetAddress.getHostAddress(), typeId, logId.toString());
    }

    @Override
    public void unpunished(InetAddress inetAddress, int typeId) {
        this.database.updateCallable(Procedure.DELETE.getName(), inetAddress.getHostAddress(), typeId);
    }

    @Override
    public List<String> getIps(int typeId) {
        return this.database.queryListCallable(Procedure.GET_ALL.getName(), new LinkedList(), resultSet -> resultSet.getString("IPAddress"), typeId);
    }

    @Override
    public UUID getLogId(InetAddress inetAddress, int typeId) {
        String id = this.database.queryCallable(Procedure.GET_BY_ID.getName(), null, resultSet -> resultSet.getString("LogID"), inetAddress.getHostAddress(), typeId);
        return id != null ? UUID.fromString(id) : null;
    }

    @Override
    public int getReasonId(InetAddress inetAddress, int typeId) {
        UUID logId = this.getLogId(inetAddress, typeId);
        return logId != null ? this.log.getReasonId(logId, typeId) : -1;
    }

    @Override
    public void setReasonId(InetAddress inetAddress, int typeId, int executorId, int reasonId) {
        UUID logId = this.getLogId(inetAddress, typeId);
        this.log.setReasonId(logId, typeId, executorId, reasonId);
    }

    @Override
    public String getReason(InetAddress inetAddress, int typeId) {
        int reasonId = this.getReasonId(inetAddress, typeId);
        return this.reason.getReason(reasonId, typeId);
    }

    @Override
    public long getDuration(InetAddress inetAddress, int typeId) {
        int reasonId = this.getReasonId(inetAddress, typeId);
        return this.reason.getDuration(reasonId, typeId);
    }

    @Override
    public Timestamp getExpiredAt(InetAddress inetAddress, int typeId) {
        UUID logId = this.getLogId(inetAddress, typeId);
        return logId != null ? this.log.getExpiredAt(logId, typeId) : null;
    }

    @Override
    public void setExpiredAt(InetAddress inetAddress, int typeId, int executorId, long time) {
        UUID logId = this.getLogId(inetAddress, typeId);
        this.log.setExpiredAt(logId, typeId, executorId, time);
    }

    @Override
    public boolean isPunished(InetAddress inetAddress, int typeId) {
        UUID logId = this.getLogId(inetAddress, typeId);
        return logId != null && !this.log.isExpired(logId, typeId);
    }

    @Override
    public int getCreatedBy(InetAddress inetAddress, int typeId) {
        UUID logId = this.getLogId(inetAddress, typeId);
        return logId != null ? this.log.getCreatedBy(logId, typeId) : -2;
    }

    @Override
    public Timestamp getCreatedAt(InetAddress inetAddress, int typeId) {
        UUID logId = this.getLogId(inetAddress, typeId);
        return logId != null ? this.log.getCreatedAt(logId, typeId) : null;
    }

    @Override
    public int getModifiedBy(InetAddress inetAddress, int typeId) {
        UUID logId = this.getLogId(inetAddress, typeId);
        return logId != null ? this.log.getModifiedBy(logId, typeId) : -2;
    }

    @Override
    public Timestamp getModifiedAt(InetAddress inetAddress, int typeId) {
        UUID logId = this.getLogId(inetAddress, typeId);
        return logId != null ? this.log.getModifiedAt(logId, typeId) : null;
    }

    private static enum Procedure {
        GET_BY_ID("PunishmentIPs_GetById", "ip INET6, tid INT", "SELECT * FROM [TABLE] WHERE IPAddress=ip AND TypeID=tid;"),
        GET_ALL("PunishmentIPs_GetAll", "tid INT", "SELECT IPAddress FROM [TABLE] WHERE TypeID=tid;"),
        CREATE("PunishmentIPs_Create", "ip INET6, tid INT, lid UUID", "INSERT INTO [TABLE] VALUES (ip,tid,lid);"),
        DELETE("PunishmentIPs_Delete", "ip INET6, tid INT", "DELETE FROM [TABLE] WHERE IPAddress=ip AND TypeID=tid;");

        private static final Procedure[] VALUES;
        private final String name;
        private final String query;

        private Procedure(String name, String input, String query) {
            this.name = name;
            this.query = Database.getProcedureQuery(name, input, query);
        }

        public String getName() {
            return this.name;
        }

        public String getQuery() {
            return this.query.replace("[TABLE]", PunishmentIPProvider.TABLE_NAME);
        }

        private static void loadAll(Database database) {
            for (Procedure procedure : VALUES) {
                database.update(procedure.getQuery(), new Object[0]);
            }
        }

        static {
            VALUES = Procedure.values();
        }
    }
}

