/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.permission;

import de.murmelmeister.murmelapi.group.Group;
import de.murmelmeister.murmelapi.permission.Permission;
import de.murmelmeister.murmelapi.user.User;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;

public record PermissionProvider(Group group, User user) implements Permission
{
    @Override
    public List<String> getPermissions(int userId) {
        return this.getPermissionsAsync(userId).join();
    }

    public CompletableFuture<List<String>> getPermissionsAsync(int userId) {
        return CompletableFuture.supplyAsync(() -> {
            LinkedHashSet<String> permissions = new LinkedHashSet<String>(this.user.getPermission().getPermissions(userId));
            List<Integer> parentIds = this.user.getParent().getParentIds(userId);
            for (int i = parentIds.size() - 1; i >= 0; --i) {
                int parentId = parentIds.get(i);
                permissions.addAll(this.group.getPermission().getAllPermissions(this.group.getParent(), parentId));
            }
            return new LinkedList<String>(permissions);
        });
    }

    @Override
    public void loadExpired() {
        this.group.loadExpired();
        this.user.loadExpired();
    }

    @Override
    public boolean hasPermission(UUID uuid, String permission) {
        return this.hasPermission(this.user.getId(uuid), permission);
    }

    @Override
    public boolean hasPermission(int userId, String permission) {
        LinkedHashSet<String> permissions = new LinkedHashSet<String>(this.getPermissions(userId));
        boolean universal = false;
        boolean positive = false;
        for (String perm : permissions) {
            if (perm.startsWith("-")) {
                if (!this.wildcardMatchV2(perm.substring(1), permission)) continue;
                return false;
            }
            if (perm.equals("*")) {
                universal = true;
                continue;
            }
            if (!this.wildcardMatchV2(perm, permission)) continue;
            positive = true;
        }
        return universal || positive;
    }

    private boolean wildcardMatch(String pattern, String input) {
        if (pattern.isEmpty()) {
            return input.isEmpty();
        }
        if (pattern.equals("*")) {
            return true;
        }
        String[] parts = pattern.split("\\*");
        int endIndex = input.length();
        for (int i = parts.length - 1; i >= 0; --i) {
            String part = parts[i];
            int index = input.lastIndexOf(part, endIndex);
            if (index == -1 || index + part.length() < endIndex) {
                return false;
            }
            endIndex = index;
        }
        return true;
    }

    private boolean wildcardMatchV2(String pattern, String input) {
        StringBuilder regex = new StringBuilder();
        regex.append("^");
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == '*') {
                regex.append(".*");
                continue;
            }
            regex.append(Pattern.quote(String.valueOf(c)));
        }
        regex.append("$");
        return input.matches(regex.toString());
    }
}

