/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.logging;

import de.murmelmeister.murmelapi.MurmelAPI;
import de.murmelmeister.murmelapi.database.Database;
import de.murmelmeister.murmelapi.logging.ActiveSession;
import java.net.InetAddress;
import java.sql.Timestamp;
import java.util.UUID;

public final class ActiveSessionProvider
implements ActiveSession {
    private static final String TABLE_NAME = "ActiveSessions";
    private final Database database;

    public ActiveSessionProvider(Database database) {
        this.database = database;
    }

    public static void setup(Database database) {
        database.createTable(TABLE_NAME, "SessionID UUID PRIMARY KEY, UserID INT UNIQUE, FOREIGN KEY (UserID) REFERENCES Users(ID), IPAddress INET6, LoginTime DATETIME DEFAULT CURRENT_TIMESTAMP(), ClientVersion VARCHAR(100), ProtocolVersion VARCHAR(50)");
        Procedure.loadAll(database);
    }

    @Override
    public boolean existsSession(int userId) {
        return this.database.existsCallable(Procedure.IS_ONLINE.getName(), userId);
    }

    @Override
    public void startSession(int userId, InetAddress inetAddress, String clientVersion, String protocolVersion) {
        this.database.updateCallable(Procedure.START.getName(), UUID.randomUUID(), userId, inetAddress.getHostAddress(), clientVersion, protocolVersion);
    }

    @Override
    public void closeSession(int userId) {
        this.database.updateCallable(Procedure.CLOSE.getName(), userId);
    }

    @Override
    public UUID getSessionId(int userId) {
        return this.database.queryCallable(Procedure.GET_DATA.getName(), null, resultSet -> {
            String sessionId = resultSet.getString("SessionID");
            return sessionId != null ? UUID.fromString(sessionId) : null;
        }, userId);
    }

    @Override
    public String getIpAddress(int userId) {
        return this.database.queryCallable(Procedure.GET_DATA.getName(), null, resultSet -> resultSet.getString("IPAddress"), userId);
    }

    @Override
    public Timestamp getLoginTime(int userId) {
        return this.database.queryCallable(Procedure.GET_DATA.getName(), null, resultSet -> resultSet.getTimestamp("LoginTime"), userId);
    }

    @Override
    public String getLoginDate(int userId) {
        Timestamp time = this.getLoginTime(userId);
        return time == null ? "never" : MurmelAPI.getDateFormat().format(time);
    }

    @Override
    public String getClientVersion(int userId) {
        return this.database.queryCallable(Procedure.GET_DATA.getName(), null, resultSet -> resultSet.getString("ClientVersion"), userId);
    }

    @Override
    public String getProtocolVersion(int userId) {
        return this.database.queryCallable(Procedure.GET_DATA.getName(), null, resultSet -> resultSet.getString("ProtocolVersion"), userId);
    }

    @Override
    public boolean isOnline(int userId) {
        int sessions = this.database.queryCallable(Procedure.IS_ONLINE.getName(), 0, resultSet -> resultSet.getInt(TABLE_NAME), userId);
        return sessions > 0;
    }

    private static enum Procedure {
        START("ActiveSessions_Start", "session UUID, uid INT, ip INET6, cv VARCHAR(100), pv VARCHAR(50)", "INSERT INTO [TABLE] (SessionID,UserID,IPAddress,ClientVersion,ProtocolVersion) VALUES (session,uid,ip,cv,pv);"),
        CLOSE("ActiveSessions_Close", "uid INT", "INSERT INTO LoginHistory (LoginID, UserID, IPAddress, LoginTime, LogoutTime, ClientVersion, ProtocolVersion)\nSELECT SessionID, uid, IPAddress, LoginTime, CURRENT_TIMESTAMP(), ClientVersion, ProtocolVersion\nFROM [TABLE] WHERE UserID=uid;\nDELETE FROM [TABLE] WHERE UserID=uid;"),
        IS_ONLINE("ActiveSessions_IsOnline", "uid INT", "SELECT COUNT(*) AS ActiveSessions FROM [TABLE] WHERE UserID=uid;"),
        GET_DATA("ActiveSessions_GetData", "uid INT", "SELECT SessionID, IPAddress, LoginTime, ClientVersion, ProtocolVersion FROM [TABLE] WHERE UserID=uid;");

        private static final Procedure[] VALUES;
        private final String name;
        private final String query;

        private Procedure(String name, String input, String query) {
            this.name = name;
            this.query = Database.getProcedureQuery(name, input, query);
        }

        public String getName() {
            return this.name;
        }

        public String getQuery() {
            return this.query.replace("[TABLE]", ActiveSessionProvider.TABLE_NAME);
        }

        private static void loadAll(Database database) {
            for (Procedure procedure : VALUES) {
                database.update(procedure.getQuery(), new Object[0]);
            }
        }

        static {
            VALUES = Procedure.values();
        }
    }
}

