/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.group;

import de.murmelmeister.murmelapi.MurmelAPI;
import de.murmelmeister.murmelapi.database.Database;
import de.murmelmeister.murmelapi.group.Group;
import de.murmelmeister.murmelapi.group.color.GroupColor;
import de.murmelmeister.murmelapi.group.color.GroupColorProvider;
import de.murmelmeister.murmelapi.group.parent.GroupParent;
import de.murmelmeister.murmelapi.group.parent.GroupParentProvider;
import de.murmelmeister.murmelapi.group.permission.GroupPermission;
import de.murmelmeister.murmelapi.group.permission.GroupPermissionProvider;
import de.murmelmeister.murmelapi.utils.CacheManager;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public final class GroupProvider
implements Group {
    private static final String TABLE_NAME = "Groups";
    private final CacheManager<Integer, String> groupIdCache = new CacheManager();
    private final CacheManager<String, Integer> groupNameCache = new CacheManager();
    private final Database database;
    private GroupColor color;
    private GroupParent parent;
    private GroupPermission permission;

    public GroupProvider(Database database) {
        this.database = database;
        this.color = this.getColor();
        this.parent = this.getParent();
        this.permission = this.getPermission();
    }

    public static void setup(Database database) {
        database.createTable(TABLE_NAME, "ID INT PRIMARY KEY AUTO_INCREMENT, GroupName VARCHAR(100) UNIQUE, Priority INT, TeamSort VARCHAR(100), CreatedBy INT, FOREIGN KEY (CreatedBy) REFERENCES Users(ID), CreatedAt DATETIME DEFAULT CURRENT_TIMESTAMP(), ModifiedBy INT, FOREIGN KEY (ModifiedBy) REFERENCES Users(ID), ModifiedAt DATETIME DEFAULT CURRENT_TIMESTAMP() ON UPDATE CURRENT_TIMESTAMP()");
        Procedure.loadAll(database);
    }

    @Override
    public boolean existsGroup(int groupId) {
        return groupId != -1 && this.database.existsCallable(Procedure.GET_DATA_BY_ID.getName(), groupId);
    }

    @Override
    public CompletableFuture<Boolean> existsGroupAsync(int groupId) {
        return groupId == -1 ? CompletableFuture.completedFuture(false) : this.database.existsCallableAsync(Procedure.GET_DATA_BY_ID.getName(), groupId);
    }

    @Override
    public boolean existsGroup(String groupName) {
        return groupName != null && this.database.existsCallable(Procedure.GET_ID_BY_NAME.getName(), groupName);
    }

    @Override
    public CompletableFuture<Boolean> existsGroupAsync(String groupName) {
        return groupName == null ? CompletableFuture.completedFuture(false) : this.database.existsCallableAsync(Procedure.GET_ID_BY_NAME.getName(), groupName);
    }

    @Override
    public void createGroup(int executorId, String groupName, int priority, String teamId) {
        Objects.requireNonNull(groupName, "Group name cannot be null");
        Objects.requireNonNull(teamId, "Team ID cannot be null");
        String team = teamId + groupName;
        this.database.updateCallable(Procedure.CREATE.getName(), groupName, priority, team, executorId, executorId);
        int groupId = this.getUniqueId(groupName);
        if (groupId != -1) {
            this.color.createGroup(executorId, groupId);
        }
    }

    @Override
    public CompletableFuture<Integer> createGroupAsync(int executorId, String groupName, int priority, String teamId) {
        Objects.requireNonNull(groupName, "Group name cannot be null");
        Objects.requireNonNull(teamId, "Team ID cannot be null");
        String team = teamId + groupName;
        return this.database.updateCallableAsync(Procedure.CREATE.getName(), groupName, priority, team, executorId, executorId).thenApply(result -> {
            int groupId = this.getUniqueId(groupName);
            if (groupId != -1) {
                this.color.createGroup(executorId, groupId);
            }
            return result;
        });
    }

    @Override
    public void deleteGroup(int executorId, int groupId) {
        if (executorId == -2 || groupId == -1) {
            return;
        }
        String name = this.getName(groupId);
        this.database.updateCallable(Procedure.DELETE.getName(), groupId);
        this.groupNameCache.remove(name);
        this.groupIdCache.remove(groupId);
    }

    @Override
    public CompletableFuture<Integer> deleteGroupAsync(int executorId, int groupId) {
        if (executorId == -2 || groupId == -1) {
            return CompletableFuture.completedFuture(-1);
        }
        String name = this.getName(groupId);
        return this.database.updateCallableAsync(Procedure.DELETE.getName(), groupId).thenApply(result -> {
            this.groupNameCache.remove(name);
            this.groupIdCache.remove(groupId);
            return result;
        });
    }

    @Override
    public int getUniqueId(String groupName) {
        if (groupName == null) {
            return -1;
        }
        Integer cached = this.groupNameCache.get(groupName);
        return cached != null ? cached.intValue() : this.database.queryCallable(Procedure.GET_ID_BY_NAME.getName(), -1, resultSet -> {
            int id = resultSet.getInt("ID");
            if (id != -1) {
                this.groupNameCache.put(groupName, id, 1L, TimeUnit.HOURS);
            }
            return id;
        }, groupName).intValue();
    }

    @Override
    public CompletableFuture<Integer> getUniqueIdAsync(String groupName) {
        if (groupName == null) {
            return CompletableFuture.completedFuture(-1);
        }
        return this.database.queryCallableAsync(Procedure.GET_ID_BY_NAME.getName(), -1, resultSet -> {
            int id = resultSet.getInt("ID");
            if (id != -1) {
                this.groupNameCache.put(groupName, id, 1L, TimeUnit.HOURS);
            }
            return id;
        }, groupName);
    }

    @Override
    public String getName(int groupId) {
        if (groupId == -1) {
            return null;
        }
        String cached = this.groupIdCache.get(groupId);
        return cached != null ? cached : this.database.queryCallable(Procedure.GET_DATA_BY_ID.getName(), null, resultSet -> {
            String name = resultSet.getString("GroupName");
            if (name != null) {
                this.groupIdCache.put(groupId, name, 1L, TimeUnit.HOURS);
            }
            return name;
        }, groupId);
    }

    @Override
    public CompletableFuture<String> getNameAsync(int groupId) {
        if (groupId == -1) {
            return CompletableFuture.completedFuture(null);
        }
        return this.database.queryCallableAsync(Procedure.GET_DATA_BY_ID.getName(), null, resultSet -> {
            String name = resultSet.getString("GroupName");
            if (name != null) {
                this.groupIdCache.put(groupId, name, 1L, TimeUnit.HOURS);
            }
            return name;
        }, groupId);
    }

    @Override
    public void rename(int executorId, int groupId, String newName) {
        if (executorId == -2 || groupId == -1 || newName == null) {
            return;
        }
        this.database.updateCallable(Procedure.SET_GROUP_NAME.getName(), newName, groupId, executorId);
        this.rename(groupId, newName);
    }

    @Override
    public CompletableFuture<Integer> renameAsync(int executorId, int groupId, String newName) {
        if (executorId == -2 || groupId == -1 || newName == null) {
            return CompletableFuture.completedFuture(-1);
        }
        return this.database.updateCallableAsync(Procedure.SET_GROUP_NAME.getName(), newName, groupId, executorId).thenApply(result -> {
            this.rename(groupId, newName);
            return result;
        });
    }

    private void rename(int groupId, String newName) {
        String oldName = this.groupIdCache.get(groupId);
        if (oldName != null) {
            this.groupNameCache.remove(oldName);
            this.groupIdCache.remove(groupId);
        }
        this.groupNameCache.put(newName, groupId, 1L, TimeUnit.HOURS);
        this.groupIdCache.put(groupId, newName, 1L, TimeUnit.HOURS);
    }

    @Override
    public List<Integer> getUniqueIds() {
        return this.database.queryListCallable(Procedure.GET_DATA.getName(), new LinkedList(), resultSet -> resultSet.getInt("ID"), new Object[0]);
    }

    @Override
    public CompletableFuture<List<Integer>> getUniqueIdsAsync() {
        return this.database.queryListCallableAsync(Procedure.GET_DATA.getName(), new LinkedList(), resultSet -> resultSet.getInt("ID"), new Object[0]);
    }

    @Override
    public List<String> getNames() {
        return this.database.queryListCallable(Procedure.GET_DATA.getName(), new LinkedList(), resultSet -> resultSet.getString("GroupName"), new Object[0]);
    }

    @Override
    public CompletableFuture<List<String>> getNamesAsync() {
        return this.database.queryListCallableAsync(Procedure.GET_DATA.getName(), new LinkedList(), resultSet -> resultSet.getString("GroupName"), new Object[0]);
    }

    @Override
    public int getPriority(int groupId) {
        return this.database.queryCallable(Procedure.GET_DATA_BY_ID.getName(), -1, resultSet -> resultSet.getInt("Priority"), groupId);
    }

    @Override
    public CompletableFuture<Integer> getPriorityAsync(int groupId) {
        return this.database.queryCallableAsync(Procedure.GET_DATA_BY_ID.getName(), -1, resultSet -> resultSet.getInt("Priority"), groupId);
    }

    @Override
    public void setPriority(int executorId, int groupId, int priority) {
        if (executorId == -2 || groupId == -1) {
            return;
        }
        this.database.updateCallable(Procedure.SET_PRIORITY.getName(), priority, groupId, executorId);
    }

    @Override
    public CompletableFuture<Integer> setPriorityAsync(int executorId, int groupId, int priority) {
        if (executorId == -2 || groupId == -1) {
            return CompletableFuture.completedFuture(-1);
        }
        return this.database.updateCallableAsync(Procedure.SET_PRIORITY.getName(), priority, groupId, executorId);
    }

    @Override
    public String getTeamSort(int groupId) {
        return this.database.queryCallable(Procedure.GET_DATA_BY_ID.getName(), null, resultSet -> resultSet.getString("TeamSort"), groupId);
    }

    @Override
    public CompletableFuture<String> getTeamSortAsync(int groupId) {
        return this.database.queryCallableAsync(Procedure.GET_DATA_BY_ID.getName(), null, resultSet -> resultSet.getString("TeamSort"), groupId);
    }

    @Override
    public void setTeamSort(int executorId, int groupId, String teamSort) {
        if (executorId == -2 || groupId == -1 || teamSort == null) {
            return;
        }
        this.database.updateCallable(Procedure.SET_TEAM_SORT.getName(), teamSort, groupId, executorId);
    }

    @Override
    public CompletableFuture<Integer> setTeamSortAsync(int executorId, int groupId, String teamSort) {
        if (executorId == -2 || groupId == -1 || teamSort == null) {
            return CompletableFuture.completedFuture(-1);
        }
        return this.database.updateCallableAsync(Procedure.SET_TEAM_SORT.getName(), teamSort, groupId, executorId);
    }

    @Override
    public int getCreatedBy(int groupId) {
        return this.database.queryCallable(Procedure.GET_DATA_BY_ID.getName(), -2, resultSet -> resultSet.getInt("CreatedBy"), groupId);
    }

    @Override
    public CompletableFuture<Integer> getCreatedByAsync(int groupId) {
        return this.database.queryCallableAsync(Procedure.GET_DATA_BY_ID.getName(), -2, resultSet -> resultSet.getInt("CreatedBy"), groupId);
    }

    @Override
    public Timestamp getCreatedAt(int groupId) {
        return this.database.queryCallable(Procedure.GET_DATA_BY_ID.getName(), null, resultSet -> resultSet.getTimestamp("CreatedAt"), groupId);
    }

    @Override
    public CompletableFuture<Timestamp> getCreatedAtAsync(int groupId) {
        return this.database.queryCallableAsync(Procedure.GET_DATA_BY_ID.getName(), null, resultSet -> resultSet.getTimestamp("CreatedAt"), groupId);
    }

    @Override
    public String getCreatedDate(int groupId) {
        Timestamp time = this.getCreatedAt(groupId);
        return time == null ? "never" : MurmelAPI.getDateFormat().format(time);
    }

    @Override
    public CompletableFuture<String> getCreatedDateAsync(int groupId) {
        return this.database.queryCallableAsync(Procedure.GET_DATA_BY_ID.getName(), null, resultSet -> {
            Timestamp time = resultSet.getTimestamp("CreatedAt");
            return time == null ? "never" : MurmelAPI.getDateFormat().format(time);
        }, groupId);
    }

    @Override
    public int getModifiedBy(int groupId) {
        return this.database.queryCallable(Procedure.GET_DATA_BY_ID.getName(), -2, resultSet -> resultSet.getInt("ModifiedBy"), groupId);
    }

    @Override
    public CompletableFuture<Integer> getModifiedByAsync(int groupId) {
        return this.database.queryCallableAsync(Procedure.GET_DATA_BY_ID.getName(), -2, resultSet -> resultSet.getInt("ModifiedBy"), groupId);
    }

    @Override
    public Timestamp getModifiedAt(int groupId) {
        return this.database.queryCallable(Procedure.GET_DATA_BY_ID.getName(), null, resultSet -> resultSet.getTimestamp("ModifiedAt"), groupId);
    }

    @Override
    public CompletableFuture<Timestamp> getModifiedAtAsync(int groupId) {
        return this.database.queryCallableAsync(Procedure.GET_DATA_BY_ID.getName(), null, resultSet -> resultSet.getTimestamp("ModifiedAt"), groupId);
    }

    @Override
    public String getModifiedDate(int groupId) {
        Timestamp time = this.getModifiedAt(groupId);
        return time == null ? "never" : MurmelAPI.getDateFormat().format(time);
    }

    @Override
    public CompletableFuture<String> getModifiedDateAsync(int groupId) {
        return this.database.queryCallableAsync(Procedure.GET_DATA_BY_ID.getName(), null, resultSet -> {
            Timestamp time = resultSet.getTimestamp("ModifiedAt");
            return time == null ? "never" : MurmelAPI.getDateFormat().format(time);
        }, groupId);
    }

    @Override
    public void createDefaultGroup(String groupName) {
        if (groupName == null) {
            return;
        }
        if (this.existsGroup(groupName)) {
            return;
        }
        int createdBy = -1;
        int priority = 1;
        String teamId = "9999" + groupName;
        this.createGroup(createdBy, groupName, priority, teamId);
        this.color.createGroup(createdBy, this.getUniqueId(groupName), "<gray>", "", "", "", "", "<gray>", "", "", "7");
    }

    @Override
    public CompletableFuture<Void> createDefaultGroupAsync(String groupName) {
        return CompletableFuture.runAsync(() -> this.createDefaultGroup(groupName));
    }

    @Override
    public void loadExpired() {
        this.parent.loadExpired();
        this.permission.loadExpired();
    }

    @Override
    public GroupColor getColor() {
        if (this.color == null) {
            this.color = new GroupColorProvider(this.database);
        }
        return this.color;
    }

    @Override
    public GroupParent getParent() {
        if (this.parent == null) {
            this.parent = new GroupParentProvider(this.database);
        }
        return this.parent;
    }

    @Override
    public GroupPermission getPermission() {
        if (this.permission == null) {
            this.permission = new GroupPermissionProvider(this.database);
        }
        return this.permission;
    }

    private static enum Procedure {
        GET_DATA_BY_ID("Groups_GetDataById", "gid INT", "SELECT * FROM [TABLE] WHERE ID=gid;"),
        GET_ID_BY_NAME("Groups_GetIdByName", "gname VARCHAR(100)", "SELECT ID FROM [TABLE] WHERE GroupName=gname;"),
        GET_DATA("Groups_GetData", "", "SELECT ID, GroupName FROM [TABLE];"),
        CREATE("Groups_Create", "gname VARCHAR(100), prio INT, tsort VARCHAR(100), created INT, modified INT", "INSERT INTO [TABLE] (GroupName,Priority,TeamSort,CreatedBy,ModifiedBy) VALUES (gname,prio,tsort,created,modified);"),
        DELETE("Groups_Delete", "gid INT", "DELETE FROM [TABLE] WHERE ID=gid;"),
        SET_PRIORITY("Groups_SetPriority", "prio INT, gid INT, modified INT", "UPDATE [TABLE] SET Priority=prio, ModifiedBy=modified WHERE ID=gid;"),
        SET_TEAM_SORT("Groups_SetTeamSort", "tsort VARCHAR(100), gid INT, modified INT", "UPDATE [TABLE] SET TeamSort=tsort, ModifiedBy=modified WHERE ID=gid;"),
        SET_GROUP_NAME("Groups_SetGroupName", "gname VARCHAR(100), gid INT, modified INT", "UPDATE [TABLE] SET GroupName=gname, ModifiedBy=modified WHERE ID=gid;");

        private static final Procedure[] VALUES;
        private final String name;
        private final String query;

        private Procedure(String name, String input, String query) {
            this.name = name;
            this.query = Database.getProcedureQuery(name, input, query);
        }

        public String getName() {
            return this.name;
        }

        public String getQuery() {
            return this.query.replace("[TABLE]", GroupProvider.TABLE_NAME);
        }

        private static void loadAll(Database database) {
            for (Procedure procedure : VALUES) {
                database.update(procedure.getQuery(), new Object[0]);
            }
        }

        static {
            VALUES = Procedure.values();
        }
    }
}

