/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Base64;
import org.bukkit.inventory.ItemStack;

public final class InventoryUtil {
    /*
     * Enabled aggressive exception aggregation
     */
    public static String saveItems(ItemStack[] items) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            String string;
            try (DataOutputStream dataOutputStream = new DataOutputStream(outputStream);){
                dataOutputStream.writeInt(items.length);
                for (ItemStack item : items) {
                    if (item != null) {
                        dataOutputStream.writeBoolean(true);
                        byte[] itemBytes = item.serializeAsBytes();
                        dataOutputStream.writeInt(itemBytes.length);
                        dataOutputStream.write(itemBytes);
                        continue;
                    }
                    dataOutputStream.writeBoolean(false);
                }
                string = Base64.getEncoder().encodeToString(outputStream.toByteArray());
            }
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to save items", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ItemStack[] loadItems(String data) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64.getDecoder().decode(data));){
            ItemStack[] itemStackArray;
            try (DataInputStream dataInputStream = new DataInputStream(inputStream);){
                ItemStack[] items = new ItemStack[dataInputStream.readInt()];
                for (int i = 0; i < items.length; ++i) {
                    boolean exist = dataInputStream.readBoolean();
                    if (exist) {
                        int itemLength = dataInputStream.readInt();
                        byte[] itemBytes = new byte[itemLength];
                        dataInputStream.readFully(itemBytes);
                        items[i] = ItemStack.deserializeBytes((byte[])itemBytes);
                        continue;
                    }
                    items[i] = null;
                }
                itemStackArray = items;
            }
            return itemStackArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load items", e);
        }
    }
}

