/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.listener.listeners;

import de.murmelmeister.citybuild.CityBuild;
import de.murmelmeister.citybuild.listener.ListenerManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.title.Title;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;

public class ConnectListener
extends ListenerManager {
    public ConnectListener(CityBuild plugin) {
        super(plugin);
    }

    @EventHandler
    public void handlePlayerJoin(PlayerJoinEvent event) {
        int userId;
        Player player = event.getPlayer();
        if (this.config.getBoolean(Configs.EVENT_ENABLE_PLAYER_JOIN)) {
            if (player.canSee(player)) {
                if (this.config.getBoolean(Configs.PREFIX_ENABLE)) {
                    event.joinMessage(MiniMessage.miniMessage().deserialize((Object)(this.message.prefix() + this.message.getString(Messages.EVENT_PLAYER_JOIN).replace("[PLAYER]", player.getName()))));
                } else {
                    event.joinMessage(MiniMessage.miniMessage().deserialize((Object)this.message.getString(Messages.EVENT_PLAYER_JOIN).replace("[PLAYER]", player.getName())));
                }
            } else {
                event.joinMessage(null);
            }
        } else {
            event.joinMessage(null);
        }
        if (this.locations.isSpawnExist()) {
            if (this.config.getBoolean(Configs.EVENT_ENABLE_TELEPORT_TO_SPAWN)) {
                player.teleport(this.locations.getLocation("Spawn"));
            }
        } else {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.EVENT_SPAWN_NOT_EXIST).replace("[PREFIX]", this.message.prefix()));
        }
        if (!this.economy.existUser(userId = this.user.getId(player.getUniqueId()))) {
            this.economy.createUser(userId, this.config.getDouble(Configs.ECONOMY_DEFAULT_MONEY), this.config.getDouble(Configs.ECONOMY_DEFAULT_BANK_MONEY));
        }
        if (player.hasPermission(this.config.getString(Configs.PERMISSION_JOIN_FLY))) {
            player.setAllowFlight(true);
            player.setFlying(true);
            this.sendMessage((CommandSender)player, this.message.getString(Messages.EVENT_JOIN_AUTO_FLY));
        }
        if (player.hasPermission(this.config.getString(Configs.PERMISSION_JOIN_GOD_MODE))) {
            this.listUtil.getGodMode().add(player.getUniqueId());
            this.sendMessage((CommandSender)player, this.message.getString(Messages.EVENT_JOIN_AUTO_GOD_MODE));
        }
        if (this.config.getBoolean(Configs.EVENT_ENABLE_JOIN_MESSAGE)) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.EVENT_JOIN_MESSAGE).replace("[PREFIX]", this.message.prefix()).replace("[PLAYER]", player.getName()));
        }
        if (this.config.getBoolean(Configs.EVENT_ENABLE_JOIN_TITLE)) {
            Title title = Title.title((Component)MiniMessage.miniMessage().deserialize((Object)this.message.getString(Messages.EVENT_JOIN_TITLE).replace("[PREFIX]", this.message.prefix()).replace("[PLAYER]", player.getName())), (Component)MiniMessage.miniMessage().deserialize((Object)this.message.getString(Messages.EVENT_JOIN_SUB_TITLE).replace("[PREFIX]", this.message.prefix()).replace("[PLAYER]", player.getName())));
            player.showTitle(title);
        }
        player.updateCommands();
        if (this.playerInventory.existInventory(userId)) {
            this.playerInventory.setInventory(userId, player);
        } else {
            this.playerInventory.createOrUpdateInventory(userId, player, false);
        }
        for (int i = 1; i < this.config.getInt(Configs.ENDER_CHEST_LIMIT) + 1; ++i) {
            if (this.enderChestEditor.exists(userId, i)) continue;
            Inventory inventory = player.getServer().createInventory(null, 54, (Component)Component.text((String)""));
            this.enderChestEditor.createOrUpdate(userId, i, inventory, false);
        }
    }

    @EventHandler
    public void handlePlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.config.getBoolean(Configs.EVENT_ENABLE_PLAYER_QUIT)) {
            if (player.canSee(player)) {
                if (this.config.getBoolean(Configs.PREFIX_ENABLE)) {
                    event.quitMessage(MiniMessage.miniMessage().deserialize((Object)(this.message.prefix() + this.message.getString(Messages.EVENT_PLAYER_QUIT).replace("[PLAYER]", player.getName()))));
                } else {
                    event.quitMessage(MiniMessage.miniMessage().deserialize((Object)this.message.getString(Messages.EVENT_PLAYER_QUIT).replace("[PLAYER]", player.getName())));
                }
            } else {
                event.quitMessage(null);
            }
        } else {
            event.quitMessage(null);
        }
        this.listUtil.getGodMode().remove(player.getUniqueId());
        this.listUtil.getLive().remove(player.getUniqueId());
        int userId = this.user.getId(player.getUniqueId());
        this.playerInventory.createOrUpdateInventory(userId, player, true);
    }
}

