/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.listener;

import de.murmelmeister.citybuild.CityBuild;
import de.murmelmeister.citybuild.api.Cooldown;
import de.murmelmeister.citybuild.api.Locations;
import de.murmelmeister.citybuild.api.PlayerInventory;
import de.murmelmeister.citybuild.api.economy.Economy;
import de.murmelmeister.citybuild.api.enderchest.EnderChestEditor;
import de.murmelmeister.citybuild.api.home.Home;
import de.murmelmeister.citybuild.files.ConfigFile;
import de.murmelmeister.citybuild.files.MessageFile;
import de.murmelmeister.citybuild.listener.listeners.ConnectListener;
import de.murmelmeister.citybuild.listener.listeners.GodModeListener;
import de.murmelmeister.citybuild.listener.listeners.LoggingListener;
import de.murmelmeister.citybuild.listener.listeners.RespawnListener;
import de.murmelmeister.citybuild.util.ListUtil;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.murmelapi.user.User;
import java.text.DecimalFormat;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ListenerManager
implements Listener {
    protected final CityBuild plugin;
    protected final ListUtil listUtil;
    protected final User user;
    protected final ConfigFile config;
    protected final MessageFile message;
    protected final Cooldown cooldown;
    protected final Locations locations;
    protected final Home homes;
    protected final Economy economy;
    protected final PlayerInventory playerInventory;
    protected final EnderChestEditor enderChestEditor;
    protected final DecimalFormat decimalFormat;

    public ListenerManager(CityBuild plugin) {
        this.plugin = plugin;
        this.listUtil = plugin.getListUtil();
        this.user = plugin.getUser();
        this.config = plugin.getConfigFile();
        this.message = plugin.getMessageFile();
        this.cooldown = plugin.getCooldown();
        this.locations = plugin.getLocations();
        this.homes = plugin.getHomes();
        this.economy = plugin.getEconomy();
        this.playerInventory = plugin.getPlayerInventory();
        this.enderChestEditor = plugin.getEnderChestEditor();
        this.decimalFormat = new DecimalFormat(this.config.getString(Configs.PATTERN_DECIMAL));
    }

    public static void register(CityBuild plugin) {
        ListenerManager.addListener((Plugin)plugin, new GodModeListener(plugin));
        ListenerManager.addListener((Plugin)plugin, new ConnectListener(plugin));
        ListenerManager.addListener((Plugin)plugin, new RespawnListener(plugin));
        ListenerManager.addListener((Plugin)plugin, new LoggingListener(plugin));
    }

    private static void addListener(Plugin plugin, Listener listener) {
        plugin.getServer().getPluginManager().registerEvents(listener, plugin);
    }

    public void sendMessage(CommandSender sender, String message) {
        if (this.config.getBoolean(Configs.PREFIX_ENABLE)) {
            sender.sendMessage(MiniMessage.miniMessage().deserialize((Object)(this.message.prefix() + message)));
        } else {
            sender.sendMessage(MiniMessage.miniMessage().deserialize((Object)message));
        }
    }
}

