/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.files;

import de.murmelmeister.citybuild.CityBuild;
import de.murmelmeister.citybuild.util.FileUtil;
import de.murmelmeister.citybuild.util.config.Messages;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.slf4j.Logger;

public class MessageFile {
    private final Logger logger;
    private File file;
    private YamlConfiguration config;

    public MessageFile(Logger logger) {
        this.logger = logger;
        this.load();
    }

    public void reloadFile() {
        this.create();
    }

    private void create() {
        this.file = FileUtil.createFile(this.logger, CityBuild.getMainPath(), "message.yml");
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    private void load() {
        this.create();
        for (Messages messages : Messages.VALUES) {
            if (this.getString(messages) != null) continue;
            this.set(messages);
        }
        this.save();
    }

    private void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void set(Messages messages) {
        this.config.set(messages.getPath(), (Object)messages.getValue());
    }

    public String getString(Messages messages) {
        return this.config.getString(messages.getPath());
    }

    public String prefix() {
        return this.getString(Messages.PREFIX);
    }
}

