/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.files;

import de.murmelmeister.citybuild.CityBuild;
import de.murmelmeister.citybuild.util.FileUtil;
import de.murmelmeister.citybuild.util.config.Configs;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.slf4j.Logger;

public class ConfigFile {
    private final Logger logger;
    private File file;
    private YamlConfiguration config;

    public ConfigFile(Logger logger) {
        this.logger = logger;
        this.load();
    }

    public void reloadFile() {
        this.create();
    }

    private void create() {
        this.file = FileUtil.createFile(this.logger, CityBuild.getMainPath(), "config.yml");
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    private void load() {
        this.create();
        for (Configs configs : Configs.VALUES) {
            if (this.get(configs) != null) continue;
            this.set(configs);
        }
        this.save();
    }

    private void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void set(Configs configs) {
        this.config.set(configs.getPath(), configs.getValue());
    }

    private Object get(Configs configs) {
        return this.config.get(configs.getPath());
    }

    public String getString(Configs configs) {
        return this.config.getString(configs.getPath());
    }

    public boolean getBoolean(Configs configs) {
        return this.config.getBoolean(configs.getPath());
    }

    public int getInt(Configs configs) {
        return this.config.getInt(configs.getPath());
    }

    public long getLong(Configs configs) {
        return this.config.getLong(configs.getPath());
    }

    public double getDouble(Configs configs) {
        return this.config.getDouble(configs.getPath());
    }
}

