/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands.shop.item;

import de.murmelmeister.citybuild.CityBuild;
import de.murmelmeister.citybuild.api.economy.EconomyProvider;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public final class ShopItemCommand
extends CommandManager {
    public ShopItemCommand(CityBuild plugin) {
        super(plugin);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_SHOP_ITEM)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_SHOP_ITEM)) {
            return true;
        }
        if (args.length == 1 && args[0].equals("adddefault")) {
            this.customItems.addDefaultMaterials();
            return true;
        }
        if (args.length == 1 && args[0].equals("import")) {
            this.shopItem.importCSV(this.logger, this.config, this.customItems, this.shopCategory);
            this.sendMessage(sender, this.message.getString(Messages.SHOP_ITEM_IMPORT).replace("[FILE]", this.config.getString(Configs.IMPORT_DATA_SHOP_ITEMS)));
            return true;
        }
        switch (args[0]) {
            case "add": {
                this.addItem(sender, command, args);
                break;
            }
            case "remove": {
                this.removeItem(sender, command, args);
                break;
            }
            case "edit": {
                this.editItem(sender, command, args);
                break;
            }
            default: {
                this.sendMessage(sender, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
            }
        }
        return true;
    }

    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (args.length == 1) {
            return this.tabComplete(Arrays.asList("add", "remove", "edit", "import", "adddefault"), args);
        }
        if (args.length == 2) {
            return this.tabComplete(this.customItems.getInternNames(), args);
        }
        if (args.length == 3) {
            return this.tabComplete(this.shopCategory.getInternNames(), args);
        }
        if (args.length == 4 && args[0].equals("add")) {
            return this.tabComplete(Arrays.stream(Material.values()).map(Enum::name).collect(Collectors.toList()), args);
        }
        if (args.length == 4 && args[0].equals("edit")) {
            return this.tabComplete(Arrays.asList("buy", "sell", "icon"), args);
        }
        if (args.length == 5 && args[0].equals("edit") && args[3].equals("icon")) {
            return this.tabComplete(Arrays.stream(Material.values()).map(Enum::name).collect(Collectors.toList()), args);
        }
        if (args.length == 5 && args[0].equals("edit") && args[3].equals("category")) {
            return this.tabComplete(this.shopCategory.getInternNames(), args);
        }
        return Collections.emptyList();
    }

    private void addItem(CommandSender sender, Command command, String[] args) {
        if (args.length < 5) {
            this.sendMessage(sender, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
            return;
        }
        String internNameItem = args[1];
        UUID customItemId = this.customItems.getCustomItemId(internNameItem);
        if (!this.customItems.existsItem(customItemId)) {
            this.sendMessage(sender, this.message.getString(Messages.SHOP_ITEM_NOT_EXIST));
            return;
        }
        String internNameCategory = args[2];
        UUID categoryId = this.shopCategory.getCategoryId(internNameCategory);
        if (!this.shopCategory.existsCategory(categoryId)) {
            this.sendMessage(sender, this.message.getString(Messages.SHOP_CATEGORY_NOT_EXIST));
            return;
        }
        String materialName = args[3];
        Material material = Material.getMaterial((String)materialName);
        if (material == null) {
            this.sendMessage(sender, this.message.getString(Messages.INVALID_ITEM));
            return;
        }
        String buy = args[4];
        String sell = args[5];
        if (!EconomyProvider.MONEY_PATTERN.matcher(buy).matches() || !EconomyProvider.MONEY_PATTERN.matcher(sell).matches()) {
            this.sendMessage(sender, this.message.getString(Messages.INVALID_NUMBERS));
            return;
        }
        double buyPrice = Double.parseDouble(buy);
        double sellPrice = Double.parseDouble(sell);
        this.shopItem.addItem(customItemId, categoryId, material, buyPrice, sellPrice);
        this.sendMessage(sender, this.message.getString(Messages.SHOP_ITEM_ADD));
    }

    private void removeItem(CommandSender sender, Command command, String[] args) {
        if (args.length < 2) {
            this.sendMessage(sender, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
            return;
        }
        String internNameItem = args[1];
        UUID customItemId = this.customItems.getCustomItemId(internNameItem);
        if (!this.customItems.existsItem(customItemId)) {
            this.sendMessage(sender, this.message.getString(Messages.SHOP_ITEM_NOT_EXIST));
            return;
        }
        UUID itemId = this.shopItem.getItemId(customItemId);
        if (!this.shopItem.existsItem(itemId)) {
            this.sendMessage(sender, this.message.getString(Messages.SHOP_ITEM_NOT_EXIST));
            return;
        }
        this.shopItem.removeItem(itemId);
        this.sendMessage(sender, this.message.getString(Messages.SHOP_ITEM_REMOVE));
    }

    private void editItem(CommandSender sender, Command command, String[] args) {
        if (args.length < 5) {
            this.sendMessage(sender, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
            return;
        }
        String internNameItem = args[1];
        UUID customItemId = this.customItems.getCustomItemId(internNameItem);
        if (!this.customItems.existsItem(customItemId)) {
            this.sendMessage(sender, this.message.getString(Messages.SHOP_ITEM_NOT_EXIST));
            return;
        }
        UUID itemId = this.shopItem.getItemId(customItemId);
        if (!this.shopItem.existsItem(itemId)) {
            this.sendMessage(sender, this.message.getString(Messages.SHOP_ITEM_NOT_EXIST));
            return;
        }
        switch (args[2]) {
            case "buy": {
                String buy = args[3];
                if (!EconomyProvider.MONEY_PATTERN.matcher(buy).matches()) {
                    this.sendMessage(sender, this.message.getString(Messages.INVALID_NUMBERS));
                    return;
                }
                double buyPrice = Double.parseDouble(buy);
                this.shopItem.updateBuyPrice(itemId, buyPrice);
                this.sendMessage(sender, this.message.getString(Messages.SHOP_ITEM_EDIT));
                break;
            }
            case "sell": {
                String sell = args[3];
                if (!EconomyProvider.MONEY_PATTERN.matcher(sell).matches()) {
                    this.sendMessage(sender, this.message.getString(Messages.INVALID_NUMBERS));
                    return;
                }
                double sellPrice = Double.parseDouble(sell);
                this.shopItem.updateSellPrice(itemId, sellPrice);
                this.sendMessage(sender, this.message.getString(Messages.SHOP_ITEM_EDIT));
                break;
            }
            case "icon": {
                String materialName = args[3];
                Material material = Material.getMaterial((String)materialName);
                if (material == null) {
                    this.sendMessage(sender, this.message.getString(Messages.INVALID_ITEM));
                    return;
                }
                this.shopItem.updateIcon(itemId, material);
                this.sendMessage(sender, this.message.getString(Messages.SHOP_ITEM_EDIT));
                break;
            }
            case "category": {
                String categoryName = args[3];
                UUID categoryId = this.shopCategory.getCategoryId(categoryName);
                if (!this.shopCategory.existsCategory(categoryId)) {
                    this.sendMessage(sender, this.message.getString(Messages.SHOP_CATEGORY_NOT_EXIST));
                    return;
                }
                this.shopItem.updateCategory(itemId, categoryId);
                this.sendMessage(sender, this.message.getString(Messages.SHOP_ITEM_EDIT));
                break;
            }
            default: {
                this.sendMessage(sender, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
            }
        }
    }
}

