/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands.shop.category;

import de.murmelmeister.citybuild.CityBuild;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public final class ShopCategoryCommand
extends CommandManager {
    public ShopCategoryCommand(CityBuild plugin) {
        super(plugin);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_SHOP_CATEGORY)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_SHOP_CATEGORY)) {
            return true;
        }
        if (args.length == 1 && args[0].equals("import")) {
            this.shopCategory.importCSV(this.logger, this.config);
            this.sendMessage(sender, this.message.getString(Messages.SHOP_CATEGORY_IMPORT).replace("[FILE]", this.config.getString(Configs.IMPORT_DATA_SHOP_CATEGORIES)));
            return true;
        }
        switch (args[0]) {
            case "add": {
                this.addCategory(sender, command, args);
                break;
            }
            case "remove": {
                this.removeCategory(sender, command, args);
                break;
            }
            case "edit": {
                this.editCategory(sender, command, args);
                break;
            }
            default: {
                this.sendMessage(sender, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
            }
        }
        return true;
    }

    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (args.length == 1) {
            return this.tabComplete(Arrays.asList("add", "remove", "edit", "import"), args);
        }
        if (args.length == 2 && (args[0].equals("remove") || args[0].equals("edit"))) {
            return this.tabComplete(this.shopCategory.getInternNames(), args);
        }
        if (args.length == 3 && args[0].equals("add")) {
            return this.tabComplete(Arrays.stream(Material.values()).map(Enum::name).collect(Collectors.toList()), args);
        }
        if (args.length == 3 && args[0].equals("edit")) {
            return this.tabComplete(Arrays.asList("icon", "displayname", "description"), args);
        }
        if (args.length == 4 && args[0].equals("edit") && args[2].equals("icon")) {
            return this.tabComplete(Arrays.stream(Material.values()).map(Enum::name).collect(Collectors.toList()), args);
        }
        return Collections.emptyList();
    }

    private void addCategory(CommandSender sender, Command command, String[] args) {
        int i;
        if (args.length < 4) {
            this.sendMessage(sender, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
            return;
        }
        String internName = args[1];
        if (this.shopCategory.existsCategory(internName)) {
            this.sendMessage(sender, this.message.getString(Messages.SHOP_CATEGORY_EXIST));
            return;
        }
        String materialName = args[2];
        Material material = Material.getMaterial((String)materialName);
        if (material == null) {
            this.sendMessage(sender, this.message.getString(Messages.INVALID_ITEM));
            return;
        }
        StringBuilder displayNameBuilder = new StringBuilder();
        if (!args[i].startsWith("\"")) {
            this.sendMessage(sender, this.message.getString(Messages.COMMAND_USE_INVERT_COMMAS));
            return;
        }
        for (i = 3; i < args.length; ++i) {
            displayNameBuilder.append(args[i]).append(" ");
            if (args[i].endsWith("\"")) break;
        }
        String displayName = displayNameBuilder.toString().trim();
        displayName = displayName.substring(1, displayName.length() - 1);
        String description = null;
        if (++i < args.length) {
            StringBuilder descriptionBuilder = new StringBuilder();
            while (i < args.length) {
                descriptionBuilder.append(args[i]).append(" ");
                ++i;
            }
            description = descriptionBuilder.toString().trim();
        }
        this.shopCategory.addCategory(internName, displayName, material, description);
        this.sendMessage(sender, this.message.getString(Messages.SHOP_CATEGORY_ADD));
    }

    private void removeCategory(CommandSender sender, Command command, String[] args) {
        if (args.length < 2) {
            this.sendMessage(sender, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
            return;
        }
        String internName = args[1];
        if (!this.shopCategory.existsCategory(internName)) {
            this.sendMessage(sender, this.message.getString(Messages.SHOP_CATEGORY_NOT_EXIST));
            return;
        }
        UUID categoryId = this.shopCategory.getCategoryId(internName);
        this.shopCategory.removeCategory(categoryId);
        this.sendMessage(sender, this.message.getString(Messages.SHOP_CATEGORY_REMOVE));
    }

    private void editCategory(CommandSender sender, Command command, String[] args) {
        if (args.length < 4) {
            this.sendMessage(sender, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
            return;
        }
        String internName = args[1];
        if (!this.shopCategory.existsCategory(internName)) {
            this.sendMessage(sender, this.message.getString(Messages.SHOP_CATEGORY_NOT_EXIST));
            return;
        }
        UUID categoryId = this.shopCategory.getCategoryId(internName);
        switch (args[2]) {
            case "icon": {
                Material material = Material.getMaterial((String)args[3]);
                if (material == null) {
                    this.sendMessage(sender, this.message.getString(Messages.INVALID_ITEM));
                    return;
                }
                this.shopCategory.updateIcon(categoryId, material);
                this.sendMessage(sender, this.message.getString(Messages.SHOP_CATEGORY_EDIT));
                break;
            }
            case "displayname": {
                StringBuilder builder = new StringBuilder();
                for (int i = 3; i < args.length; ++i) {
                    builder.append(args[i]).append(" ");
                }
                String displayName = builder.toString().trim();
                this.shopCategory.updateDisplayName(categoryId, displayName);
                this.sendMessage(sender, this.message.getString(Messages.SHOP_CATEGORY_EDIT));
                break;
            }
            case "description": {
                StringBuilder builder = new StringBuilder();
                for (int i = 3; i < args.length; ++i) {
                    builder.append(args[i]).append(" ");
                }
                String description = builder.toString().trim();
                this.shopCategory.updateDescription(categoryId, description);
                this.sendMessage(sender, this.message.getString(Messages.SHOP_CATEGORY_EDIT));
                break;
            }
            default: {
                this.sendMessage(sender, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
            }
        }
    }
}

