/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands.shop;

import de.murmelmeister.citybuild.CityBuild;
import de.murmelmeister.citybuild.api.shop.ShopMenu;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class ShopCommand
extends CommandManager {
    public ShopCommand(CityBuild plugin) {
        super(plugin);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_SHOP_MENU)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_SHOP_MENU)) {
            return true;
        }
        Player player = this.getPlayer(sender);
        if (!this.existPlayer(sender)) {
            return true;
        }
        if (this.shopCategory.getCategories().isEmpty()) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.SHOP_CATEGORY_EMPTY));
            return true;
        }
        ShopMenu shopMenu = new ShopMenu(this.user, this.config, this.message, this.customItems, this.shopCategory, this.shopItem, this.economy);
        shopMenu.show(player);
        return true;
    }

    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        return Collections.emptyList();
    }
}

