/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands.locations;

import de.murmelmeister.citybuild.CityBuild;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveWarpCommand
extends CommandManager {
    public RemoveWarpCommand(CityBuild plugin) {
        super(plugin);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_REMOVE_LOCATION)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_REMOVE_LOCATION)) {
            return true;
        }
        Player player = this.getPlayer(sender);
        if (!this.existPlayer(sender)) {
            return true;
        }
        if (args.length != 1) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
            return true;
        }
        if (!this.locations.isLocationExist(args[0])) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_LOCATION_NOT_EXIST).replace("[LOCATION]", args[0]));
            return true;
        }
        this.locations.removeLocation(args[0]);
        this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_REMOVE_LOCATION).replace("[LOCATION]", args[0]));
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return this.tabComplete(this.locations.getLocationList(), args, 1);
    }
}

