/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands.inventories;

import de.murmelmeister.citybuild.CityBuild;
import de.murmelmeister.citybuild.api.nbt.NbtCompound;
import de.murmelmeister.citybuild.api.nbt.NbtTagFloat;
import de.murmelmeister.citybuild.api.nbt.NbtTagString;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InvseeCommand
extends CommandManager {
    public InvseeCommand(CityBuild plugin) {
        super(plugin);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_INVSEE)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_INVSEE)) {
            return true;
        }
        Player player = this.getPlayer(sender);
        if (!this.existPlayer(sender)) {
            return true;
        }
        if (args.length != 1) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
            return true;
        }
        OfflinePlayer target = player.getServer().getOfflinePlayer(args[0]);
        if (!target.hasPlayedBefore()) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.NO_PLAYER_EXIST).replace("[PLAYER]", args[0]));
            return true;
        }
        int targetId = this.user.getId(target.getUniqueId());
        if (targetId == -2) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.NO_PLAYER_EXIST).replace("[PLAYER]", args[0]));
            return true;
        }
        if (!this.playerInventory.existInventory(targetId)) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.NO_PLAYER_EXIST).replace("[PLAYER]", args[0]));
            return true;
        }
        Inventory inventory = player.getServer().createInventory(null, 45, (Component)Component.text((String)("Inventory of " + target.getName())));
        inventory.setContents(this.playerInventory.getContents(targetId));
        inventory.setStorageContents(this.playerInventory.getStorageContents(targetId));
        player.openInventory(inventory);
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        return this.tabCompleteOfflinePlayers(sender, args, 1);
    }

    private void readData(Player player, UUID uuid) {
        String mainWorld = this.getMainWorld();
        if (mainWorld == null) {
            throw new RuntimeException("Couldn't find main world");
        }
        File file = new File("./" + mainWorld + "/playerdata/", String.valueOf(uuid) + ".dat");
        NbtCompound readData = new NbtCompound();
        try (FileInputStream inputStream = new FileInputStream(file);
             DataInputStream dataInputStream = new DataInputStream(inputStream);){
            readData.read(dataInputStream);
            NbtTagString name = (NbtTagString)readData.getTag("lastKnownName");
            NbtTagFloat health = (NbtTagFloat)readData.getTag("Health");
            player.sendMessage("Name: " + name.getValue() + "; Health: " + health.getValue());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read player data", e);
        }
    }

    private String getMainWorld() {
        String string;
        Properties properties = new Properties();
        FileInputStream inputStream = new FileInputStream("./server.properties");
        try {
            properties.load(inputStream);
            string = properties.getProperty("level-name");
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        inputStream.close();
        return string;
    }
}

