/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands.homes;

import de.murmelmeister.citybuild.CityBuild;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HomeCommand
extends CommandManager {
    public HomeCommand(CityBuild plugin) {
        super(plugin);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String homeName;
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_HOME)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_HOME)) {
            return true;
        }
        Player player = this.getPlayer(sender);
        if (!this.existPlayer(sender)) {
            return true;
        }
        if (args.length != 1) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
            return true;
        }
        int userId = this.user.createOrGetUser(player.getUniqueId());
        if (!this.homes.existsHome(userId, homeName = args[0])) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_NOT_EXIST_HOME).replace("[HOME]", homeName));
            return true;
        }
        player.teleport(this.homes.getHome(player.getServer(), userId, homeName));
        this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SEND_HOME).replace("[HOME]", homeName));
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        Player player = this.getPlayer(sender);
        int userId = this.user.createOrGetUser(player.getUniqueId());
        return this.tabComplete(this.homes.getHomeNames(userId), args, 1);
    }
}

