/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands.economy;

import de.murmelmeister.citybuild.CityBuild;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SellCommand
extends CommandManager {
    public SellCommand(CityBuild plugin) {
        super(plugin);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_SELL)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_SELL)) {
            return true;
        }
        Player player = this.getPlayer(sender);
        if (!this.existPlayer(sender)) {
            return true;
        }
        if (args.length != 1) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
            return true;
        }
        ItemStack mainItem = player.getInventory().getItemInMainHand();
        if (mainItem.getType() == Material.AIR) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.INVALID_ITEM));
            return true;
        }
        UUID customItemId = this.customItems.getCustomItemId(mainItem.getType().name());
        if (!this.customItems.existsItem(customItemId)) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.INVALID_ITEM));
            return true;
        }
        UUID itemId = this.shopItem.getItemId(customItemId);
        if (!this.shopItem.existsItem(itemId)) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.INVALID_ITEM));
            return true;
        }
        double sellPrice = this.shopItem.getSellPrice(itemId);
        String displayName = this.customItems.getInternName(customItemId);
        switch (args[0]) {
            case "show": {
                this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SELL_SHOW_ONE).replace("[MONEY]", this.decimalFormat.format(sellPrice)).replace("[ITEM]", displayName));
                this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SELL_SHOW_STACK).replace("[MONEY]", this.decimalFormat.format(sellPrice * (double)mainItem.getAmount())).replace("[AMOUNT]", "" + mainItem.getAmount()).replace("[ITEM]", displayName));
                int amount = 0;
                for (ItemStack itemStack : player.getInventory().getContents()) {
                    if (itemStack == null || !itemStack.isSimilar(mainItem)) continue;
                    amount += itemStack.getAmount();
                }
                this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SELL_SHOW_INVENTORY).replace("[MONEY]", this.decimalFormat.format(sellPrice * (double)amount)).replace("[AMOUNT]", "" + amount).replace("[ITEM]", displayName));
                break;
            }
            case "one": {
                int amount = mainItem.getAmount();
                mainItem.setAmount(--amount);
                player.updateInventory();
                int userId = this.user.getId(player.getUniqueId());
                this.economy.addMoney(userId, sellPrice);
                this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SELL_ONE).replace("[MONEY]", this.decimalFormat.format(sellPrice)).replace("[ITEM]", displayName));
                this.logger.info(this.message.getString(Messages.COMMAND_SELL_LOGGER_ONE).replace("[PLAYER]", player.getName()).replace("[ITEM]", displayName).replace("[MONEY]", this.decimalFormat.format(sellPrice)));
                break;
            }
            case "stack": {
                int amount = mainItem.getAmount();
                player.getInventory().removeItem(new ItemStack[]{mainItem});
                player.updateInventory();
                int userId = this.user.getId(player.getUniqueId());
                this.economy.addMoney(userId, sellPrice * (double)amount);
                this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SELL_STACK).replace("[MONEY]", this.decimalFormat.format(sellPrice * (double)amount)).replace("[AMOUNT]", "" + amount).replace("[ITEM]", displayName));
                this.logger.info(this.message.getString(Messages.COMMAND_SELL_LOGGER_STACK).replace("[PLAYER]", player.getName()).replace("[AMOUNT]", "" + amount).replace("[ITEM]", displayName).replace("[MONEY]", this.decimalFormat.format(sellPrice * (double)amount)));
                break;
            }
            case "inventory": {
                int amount = 0;
                for (ItemStack itemStack : player.getInventory().getContents()) {
                    if (itemStack == null || !itemStack.isSimilar(mainItem)) continue;
                    amount += itemStack.getAmount();
                    player.getInventory().removeItem(new ItemStack[]{itemStack});
                }
                player.updateInventory();
                int userId = this.user.getId(player.getUniqueId());
                this.economy.addMoney(userId, sellPrice * (double)amount);
                this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SELL_INVENTORY).replace("[MONEY]", this.decimalFormat.format(sellPrice * (double)amount)).replace("[AMOUNT]", "" + amount).replace("[ITEM]", displayName));
                this.logger.info(this.message.getString(Messages.COMMAND_SELL_LOGGER_INVENTORY).replace("[PLAYER]", player.getName()).replace("[AMOUNT]", "" + amount).replace("[ITEM]", displayName).replace("[MONEY]", this.decimalFormat.format(sellPrice * (double)amount)));
                break;
            }
            default: {
                this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
            }
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull @NotNull String @NotNull [] args) {
        return this.tabComplete(Arrays.asList("show", "one", "stack", "inventory"), args, 1);
    }
}

