/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands.economy;

import de.murmelmeister.citybuild.CityBuild;
import de.murmelmeister.citybuild.api.economy.EconomyProvider;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PayCommand
extends CommandManager {
    public PayCommand(CityBuild plugin) {
        super(plugin);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_PAY)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_PAY_USE)) {
            return true;
        }
        Player player = this.getPlayer(sender);
        if (!this.existPlayer(sender)) {
            return true;
        }
        int userId = this.user.getId(player.getUniqueId());
        if (args.length != 2) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
            return true;
        }
        String username = args[0];
        String amount = args[1];
        if (!EconomyProvider.MONEY_PATTERN.matcher(amount).matches()) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.INVALID_NUMBERS));
            return true;
        }
        double money = Double.parseDouble(amount);
        if (username.equals("*")) {
            if (!this.hasPermission(sender, Configs.PERMISSION_PAY_ALL_PLAYERS)) {
                return true;
            }
            if (amount.equals("*")) {
                this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_PAY_ALL));
                return true;
            }
            this.payAllPlayers(player, userId, money);
            return true;
        }
        Player target = sender.getServer().getPlayer(username);
        if (target == null) {
            this.sendMessage(sender, this.message.getString(Messages.NO_PLAYER_EXIST).replace("[PLAYER]", username));
            return true;
        }
        int targetId = this.user.getId(target.getUniqueId());
        if (targetId == -2) {
            this.sendMessage(sender, this.message.getString(Messages.NO_PLAYER_EXIST).replace("[PLAYER]", username));
            return true;
        }
        if (args[1].equals("*")) {
            this.payAllMoney(player, target, userId, targetId);
            return true;
        }
        this.payPlayerMoney(player, target, userId, targetId, money);
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return this.tabCompletePlayers(sender, args, 1);
    }

    private void payAllPlayers(Player player, int userId, double money) {
        if (!this.economy.hasEnoughMoney(userId, money)) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_PAY_MONEY_ENOUGH));
            return;
        }
        for (Player all : player.getServer().getOnlinePlayers()) {
            int allIds;
            if (all.equals((Object)player) || (allIds = this.user.getId(all.getUniqueId())) == -2) continue;
            if (this.economy.checkAndTransferMoney(userId, allIds, money)) {
                this.sendMessage((CommandSender)all, this.message.getString(Messages.COMMAND_PAY_TARGET).replace("[PLAYER]", player.getName()).replace("[MONEY]", this.decimalFormat.format(money)));
                continue;
            }
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_PAY_MONEY_ENOUGH));
        }
        this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_PAY_PLAYER).replace("[PLAYER]", "all").replace("[MONEY]", this.decimalFormat.format(money)));
    }

    private void payAllMoney(Player player, Player target, int userId, int targetId) {
        if (!this.hasPermission((CommandSender)player, Configs.PERMISSION_PAY_ALL_MONEY)) {
            return;
        }
        double allMoney = this.economy.getMoney(userId);
        this.economy.transferMoney(userId, targetId, allMoney);
        this.sendMessage((CommandSender)target, this.message.getString(Messages.COMMAND_PAY_TARGET).replace("[PLAYER]", player.getName()).replace("[MONEY]", this.decimalFormat.format(allMoney)));
        this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_PAY_PLAYER).replace("[PLAYER]", target.getName()).replace("[MONEY]", this.decimalFormat.format(allMoney)));
    }

    private void payPlayerMoney(Player player, Player target, int userId, int targetId, double money) {
        if (this.economy.checkAndTransferMoney(userId, targetId, money)) {
            this.sendMessage((CommandSender)target, this.message.getString(Messages.COMMAND_PAY_TARGET).replace("[PLAYER]", player.getName()).replace("[MONEY]", this.decimalFormat.format(money)));
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_PAY_PLAYER).replace("[PLAYER]", target.getName()).replace("[MONEY]", this.decimalFormat.format(money)));
        } else {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_PAY_MONEY_ENOUGH));
        }
    }
}

