/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands.economy;

import de.murmelmeister.citybuild.CityBuild;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.util.List;
import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MoneyCommand
extends CommandManager {
    public MoneyCommand(CityBuild plugin) {
        super(plugin);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_MONEY_COMMAND)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_MONEY_COMMAND)) {
            return true;
        }
        Player player = this.getPlayer(sender);
        if (!this.existPlayer(sender)) {
            return true;
        }
        int userId = this.user.getId(player.getUniqueId());
        if (args.length == 0) {
            if (!this.isEnable(sender, Configs.COMMAND_ENABLE_MONEY_USE)) {
                return true;
            }
            if (!this.hasPermission(sender, Configs.PERMISSION_MONEY_USE)) {
                return true;
            }
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_MONEY_USE).replace("[MONEY]", this.economy.getFormattedMoney(userId, this.config.getString(Configs.PATTERN_DECIMAL))));
        } else if (args.length == 1) {
            if (!this.isEnable(sender, Configs.COMMAND_ENABLE_MONEY_OTHER)) {
                return true;
            }
            if (!this.hasPermission(sender, Configs.PERMISSION_MONEY_OTHER)) {
                return true;
            }
            String target = args[0];
            this.getUUIDAsync(sender, target).thenAccept(uuid -> {
                if (uuid == null) {
                    return;
                }
                if (!this.existUser(sender, (UUID)uuid, target)) {
                    return;
                }
                int targetId = this.user.getId((UUID)uuid);
                this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_MONEY_OTHER).replace("[MONEY]", this.economy.getFormattedMoney(targetId, this.config.getString(Configs.PATTERN_DECIMAL))).replace("[PLAYER]", target));
            });
        } else {
            this.sendMessage(sender, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return this.tabComplete(this.user.getUsernames(), args, 1);
    }
}

