/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands.economy;

import de.murmelmeister.citybuild.CityBuild;
import de.murmelmeister.citybuild.api.economy.EconomyProvider;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EconomyCommand
extends CommandManager {
    public EconomyCommand(CityBuild plugin) {
        super(plugin);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_ECONOMY)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_ECONOMY)) {
            return true;
        }
        if (args.length >= 2) {
            String username = args[1];
            String amount = args[2];
            if (!EconomyProvider.MONEY_PATTERN.matcher(amount).matches()) {
                this.sendMessage(sender, this.message.getString(Messages.INVALID_NUMBERS));
                return true;
            }
            double money = Double.parseDouble(amount);
            if (username.equals("*")) {
                block12: for (Player all : sender.getServer().getOnlinePlayers()) {
                    int allIds = this.user.getId(all.getUniqueId());
                    if (allIds == -2) continue;
                    switch (args[0]) {
                        case "set": {
                            this.economySet(sender, allIds, all.getName(), money);
                            continue block12;
                        }
                        case "add": {
                            this.economyAdd(sender, allIds, all.getName(), money);
                            continue block12;
                        }
                        case "remove": {
                            this.economyRemove(sender, allIds, all.getName(), money);
                            continue block12;
                        }
                        case "reset": {
                            this.economyReset(sender, allIds, all.getName());
                            continue block12;
                        }
                    }
                    this.sendMessage(sender, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
                }
                return true;
            }
            this.getUUIDAsync(sender, username).thenAccept(uuid -> {
                if (uuid == null) {
                    return;
                }
                if (!this.existUser(sender, (UUID)uuid, username)) {
                    return;
                }
                int targetId = this.user.getId((UUID)uuid);
                switch (args[0]) {
                    case "set": {
                        this.economySet(sender, targetId, username, money);
                        break;
                    }
                    case "add": {
                        this.economyAdd(sender, targetId, username, money);
                        break;
                    }
                    case "remove": {
                        this.economyRemove(sender, targetId, username, money);
                        break;
                    }
                    case "reset": {
                        this.economyReset(sender, targetId, username);
                        break;
                    }
                    default: {
                        this.sendMessage(sender, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
                    }
                }
            });
        } else {
            this.sendMessage(sender, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1) {
            return this.tabComplete(Arrays.asList("set", "add", "remove", "reset"), args);
        }
        if (args.length == 2) {
            return this.tabComplete(this.user.getUsernames(), args, 2);
        }
        return Collections.emptyList();
    }

    private void economySet(CommandSender sender, int targetId, String username, double money) {
        this.economy.setMoney(targetId, money);
        this.sendMessage(sender, this.message.getString(Messages.COMMAND_ECONOMY_SET).replace("[PLAYER]", username).replace("[MONEY]", this.decimalFormat.format(money)));
    }

    private void economyAdd(CommandSender sender, int targetId, String username, double money) {
        this.economy.addMoney(targetId, money);
        this.sendMessage(sender, this.message.getString(Messages.COMMAND_ECONOMY_ADD).replace("[PLAYER]", username).replace("[MONEY]", this.decimalFormat.format(money)));
    }

    private void economyRemove(CommandSender sender, int targetId, String username, double money) {
        this.economy.removeMoney(targetId, money);
        this.sendMessage(sender, this.message.getString(Messages.COMMAND_ECONOMY_REMOVE).replace("[PLAYER]", username).replace("[MONEY]", this.decimalFormat.format(money)));
    }

    private void economyReset(CommandSender sender, int targetId, String username) {
        this.economy.resetMoney(targetId, this.config.getDouble(Configs.ECONOMY_DEFAULT_MONEY));
        this.sendMessage(sender, this.message.getString(Messages.COMMAND_ECONOMY_RESET).replace("[PLAYER]", username));
    }
}

