/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands.economy;

import de.murmelmeister.citybuild.CityBuild;
import de.murmelmeister.citybuild.api.economy.EconomyProvider;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class BankCommand
extends CommandManager {
    public BankCommand(CityBuild plugin) {
        super(plugin);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_BANK)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_BANK)) {
            return true;
        }
        Player player = this.getPlayer(sender);
        if (!this.existPlayer(sender)) {
            return true;
        }
        int userId = this.user.getId(player.getUniqueId());
        block0 : switch (args.length) {
            case 0: {
                this.sendMessage((CommandSender)player, this.message.getString(Messages.BANK_USAGE).replace("[MONEY]", this.economy.getFormattedMoney(userId, this.config.getString(Configs.PATTERN_DECIMAL))).replace("[BANK]", this.economy.getFormattedBankMoney(userId, this.config.getString(Configs.PATTERN_DECIMAL))));
                break;
            }
            case 2: {
                String input = args[1];
                if (!EconomyProvider.MONEY_PATTERN.matcher(input).matches()) {
                    this.sendMessage((CommandSender)player, this.message.getString(Messages.INVALID_NUMBERS));
                    return true;
                }
                double amount = Double.parseDouble(input);
                switch (args[0]) {
                    case "deposit": {
                        if (this.economy.transferMoneyToBank(userId, amount)) {
                            this.sendMessage((CommandSender)player, this.message.getString(Messages.BANK_DEPOSIT).replace("[MONEY]", this.decimalFormat.format(amount)));
                            break block0;
                        }
                        this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_PAY_MONEY_ENOUGH));
                        break block0;
                    }
                    case "withdraw": {
                        if (this.economy.transferBankMoneyToPlayer(userId, amount)) {
                            this.sendMessage((CommandSender)player, this.message.getString(Messages.BANK_WITHDRAW).replace("[MONEY]", this.decimalFormat.format(amount)));
                            break block0;
                        }
                        this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_PAY_MONEY_ENOUGH));
                        break block0;
                    }
                }
                this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
                break;
            }
            default: {
                this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
            }
        }
        return true;
    }

    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        return this.tabComplete(Arrays.asList("deposit", "withdraw"), args, 1);
    }
}

