/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands;

import de.murmelmeister.citybuild.CityBuild;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RepairCommand
extends CommandManager {
    public RepairCommand(CityBuild plugin) {
        super(plugin);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_REPAIR)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_REPAIR)) {
            return true;
        }
        Player player = this.getPlayer(sender);
        if (!this.existPlayer(sender)) {
            return true;
        }
        if (player.getItemInHand().getType().equals((Object)Material.AIR)) {
            return true;
        }
        if (player.hasPermission(this.config.getString(Configs.PERMISSION_NOT_COOLDOWN))) {
            this.createItem(player.getItemInHand());
            return true;
        }
        if (this.cooldown.getDuration(player.getUniqueId(), "Repair") <= System.currentTimeMillis()) {
            this.cooldown.remove(player.getUniqueId(), "Repair");
        }
        if (this.cooldown.has(player.getUniqueId(), "Repair")) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COOLDOWN_MESSAGE).replace("[DATE]", this.cooldown.getDurationDate(this.config, player.getUniqueId(), "Repair").replace(" ", this.message.getString(Messages.COOLDOWN_DATE))));
            return true;
        }
        this.cooldown.add(player.getUniqueId(), "Repair", this.config.getLong(Configs.TIME_REPAIR_COOLDOWN));
        this.createItem(player.getItemInHand());
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return new ArrayList<String>();
    }

    private ItemStack createItem(ItemStack itemStack) {
        Damageable damageable = (Damageable)itemStack.getItemMeta();
        damageable.setDamage(0);
        itemStack.setItemMeta((ItemMeta)damageable);
        return itemStack;
    }
}

