/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands;

import de.murmelmeister.citybuild.CityBuild;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiveCommand
extends CommandManager {
    public LiveCommand(CityBuild plugin) {
        super(plugin);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_LIVE)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_LIVE)) {
            return true;
        }
        Player player = this.getPlayer(sender);
        if (!this.existPlayer(sender)) {
            return true;
        }
        if (this.listUtil.getLive().contains(player.getUniqueId())) {
            this.listUtil.getLive().remove(player.getUniqueId());
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_LIVE_OFF));
        } else {
            this.listUtil.getLive().add(player.getUniqueId());
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_LIVE_ON));
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return new ArrayList<String>();
    }
}

