/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands;

import de.murmelmeister.citybuild.CityBuild;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HealCommand
extends CommandManager {
    public HealCommand(CityBuild plugin) {
        super(plugin);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_HEAL_COMMAND)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_HEAL_COMMAND)) {
            return true;
        }
        if (args.length == 0) {
            if (!this.isEnable(sender, Configs.COMMAND_ENABLE_HEAL_USE)) {
                return true;
            }
            if (!this.hasPermission(sender, Configs.PERMISSION_HEAL_USE)) {
                return true;
            }
            Player player = this.getPlayer(sender);
            if (!this.existPlayer(sender)) {
                return true;
            }
            player.setHealth(20.0);
            player.setFoodLevel(20);
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_HEAL_USE));
        } else if (args.length == 1) {
            if (!this.isEnable(sender, Configs.COMMAND_ENABLE_HEAL_OTHER)) {
                return true;
            }
            if (!this.hasPermission(sender, Configs.PERMISSION_HEAL_OTHER)) {
                return true;
            }
            Player target = sender.getServer().getPlayer(args[0]);
            if (target == null) {
                this.sendMessage(sender, this.message.getString(Messages.NO_PLAYER_EXIST).replace("[PLAYER]", args[0]));
                return true;
            }
            target.setHealth(20.0);
            target.setFoodLevel(20);
            this.sendMessage((CommandSender)target, this.message.getString(Messages.COMMAND_HEAL_USE));
            this.sendMessage(sender, this.message.getString(Messages.COMMAND_HEAL_OTHER).replace("[PLAYER]", target.getName()));
        } else {
            this.sendMessage(sender, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return this.tabCompletePlayers(sender, args, 1);
    }
}

