/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands;

import de.murmelmeister.citybuild.CityBuild;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.util.List;
import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GodModeCommand
extends CommandManager {
    public GodModeCommand(CityBuild plugin) {
        super(plugin);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_GOD_MODE_COMMAND)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_GOD_MODE_COMMAND)) {
            return true;
        }
        if (args.length == 0) {
            if (!this.isEnable(sender, Configs.COMMAND_ENABLE_GOD_MODE_USE)) {
                return true;
            }
            if (!this.hasPermission(sender, Configs.PERMISSION_GOD_MODE_USE)) {
                return true;
            }
            Player player = this.getPlayer(sender);
            if (!this.existPlayer(sender)) {
                return true;
            }
            UUID uuid = player.getUniqueId();
            if (this.listUtil.getGodMode().contains(uuid)) {
                this.listUtil.getGodMode().remove(uuid);
                this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_GOD_MODE_USE_OFF));
            } else {
                this.listUtil.getGodMode().add(uuid);
                this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_GOD_MODE_USE_ON));
            }
        } else if (args.length == 1) {
            if (!this.isEnable(sender, Configs.COMMAND_ENABLE_GOD_MODE_OTHER)) {
                return true;
            }
            if (!this.hasPermission(sender, Configs.PERMISSION_GOD_MODE_OTHER)) {
                return true;
            }
            Player target = sender.getServer().getPlayer(args[0]);
            if (target == null) {
                this.sendMessage(sender, this.message.getString(Messages.NO_PLAYER_EXIST).replace("[PLAYER]", args[0]));
                return true;
            }
            UUID uuid = target.getUniqueId();
            if (this.listUtil.getGodMode().contains(uuid)) {
                this.listUtil.getGodMode().remove(uuid);
                this.sendMessage((CommandSender)target, this.message.getString(Messages.COMMAND_GOD_MODE_USE_OFF));
                this.sendMessage(sender, this.message.getString(Messages.COMMAND_GOD_MODE_OTHER_OFF).replace("[PLAYER]", target.getName()));
            } else {
                this.listUtil.getGodMode().add(uuid);
                this.sendMessage((CommandSender)target, this.message.getString(Messages.COMMAND_GOD_MODE_USE_ON));
                this.sendMessage(sender, this.message.getString(Messages.COMMAND_GOD_MODE_OTHER_ON).replace("[PLAYER]", target.getName()));
            }
        } else {
            this.sendMessage(sender, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return this.tabCompletePlayers(sender, args, 1);
    }
}

