/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command;

import de.murmelmeister.citybuild.CityBuild;
import de.murmelmeister.citybuild.api.Cooldown;
import de.murmelmeister.citybuild.api.Locations;
import de.murmelmeister.citybuild.api.PlayerInventory;
import de.murmelmeister.citybuild.api.economy.Economy;
import de.murmelmeister.citybuild.api.enderchest.EnderChestEditor;
import de.murmelmeister.citybuild.api.home.Home;
import de.murmelmeister.citybuild.api.item.CustomItem;
import de.murmelmeister.citybuild.api.shop.category.ShopCategory;
import de.murmelmeister.citybuild.api.shop.item.ShopItem;
import de.murmelmeister.citybuild.command.commands.CityBuildReloadCommand;
import de.murmelmeister.citybuild.command.commands.DayCommand;
import de.murmelmeister.citybuild.command.commands.FeedCommand;
import de.murmelmeister.citybuild.command.commands.FlyCommand;
import de.murmelmeister.citybuild.command.commands.GameModeCommand;
import de.murmelmeister.citybuild.command.commands.GodModeCommand;
import de.murmelmeister.citybuild.command.commands.HealCommand;
import de.murmelmeister.citybuild.command.commands.LiveCommand;
import de.murmelmeister.citybuild.command.commands.LobbyCommand;
import de.murmelmeister.citybuild.command.commands.NightCommand;
import de.murmelmeister.citybuild.command.commands.RenameCommand;
import de.murmelmeister.citybuild.command.commands.RepairCommand;
import de.murmelmeister.citybuild.command.commands.SignCommand;
import de.murmelmeister.citybuild.command.commands.UnSignCommand;
import de.murmelmeister.citybuild.command.commands.economy.BankCommand;
import de.murmelmeister.citybuild.command.commands.economy.EconomyCommand;
import de.murmelmeister.citybuild.command.commands.economy.MoneyCommand;
import de.murmelmeister.citybuild.command.commands.economy.PayCommand;
import de.murmelmeister.citybuild.command.commands.economy.SellCommand;
import de.murmelmeister.citybuild.command.commands.homes.AddHomeCommand;
import de.murmelmeister.citybuild.command.commands.homes.HomeCommand;
import de.murmelmeister.citybuild.command.commands.homes.RemoveHomeCommand;
import de.murmelmeister.citybuild.command.commands.inventories.AnvilCommand;
import de.murmelmeister.citybuild.command.commands.inventories.EnderChestCommand;
import de.murmelmeister.citybuild.command.commands.inventories.InvseeCommand;
import de.murmelmeister.citybuild.command.commands.inventories.TrashCommand;
import de.murmelmeister.citybuild.command.commands.inventories.WorkbenchCommand;
import de.murmelmeister.citybuild.command.commands.locations.RemoveWarpCommand;
import de.murmelmeister.citybuild.command.commands.locations.SetSpawnCommand;
import de.murmelmeister.citybuild.command.commands.locations.SetWarpCommand;
import de.murmelmeister.citybuild.command.commands.locations.SpawnCommand;
import de.murmelmeister.citybuild.command.commands.locations.WarpCommand;
import de.murmelmeister.citybuild.command.commands.shop.ShopCommand;
import de.murmelmeister.citybuild.command.commands.shop.category.ShopCategoryCommand;
import de.murmelmeister.citybuild.command.commands.shop.item.ShopItemCommand;
import de.murmelmeister.citybuild.command.commands.teleport.TpCommand;
import de.murmelmeister.citybuild.command.commands.teleport.TpaAcceptCommand;
import de.murmelmeister.citybuild.command.commands.teleport.TpaCommand;
import de.murmelmeister.citybuild.command.commands.teleport.TpaDenyCommand;
import de.murmelmeister.citybuild.command.commands.teleport.TpaHereCommand;
import de.murmelmeister.citybuild.files.ConfigFile;
import de.murmelmeister.citybuild.files.MessageFile;
import de.murmelmeister.citybuild.util.ListUtil;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import de.murmelmeister.murmelapi.user.User;
import de.murmelmeister.murmelapi.utils.MojangUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;
import org.slf4j.Logger;

public abstract class CommandManager
implements TabExecutor {
    protected final Logger logger;
    protected final Plugin plugin;
    protected final ListUtil listUtil;
    protected final User user;
    protected final ConfigFile config;
    protected final MessageFile message;
    protected final Cooldown cooldown;
    protected final Locations locations;
    protected final Home homes;
    protected final Economy economy;
    protected final DecimalFormat decimalFormat;
    protected final PlayerInventory playerInventory;
    protected final CustomItem customItems;
    protected final ShopCategory shopCategory;
    protected final ShopItem shopItem;
    protected final EnderChestEditor enderChestEditor;

    public CommandManager(CityBuild plugin) {
        this.logger = plugin.getSLF4JLogger();
        this.plugin = plugin;
        this.listUtil = plugin.getListUtil();
        this.user = plugin.getUser();
        this.config = plugin.getConfigFile();
        this.message = plugin.getMessageFile();
        this.cooldown = plugin.getCooldown();
        this.locations = plugin.getLocations();
        this.homes = plugin.getHomes();
        this.economy = plugin.getEconomy();
        this.playerInventory = plugin.getPlayerInventory();
        this.customItems = plugin.getCustomItems();
        this.shopCategory = plugin.getShopCategory();
        this.shopItem = plugin.getShopItem();
        this.enderChestEditor = plugin.getEnderChestEditor();
        this.decimalFormat = new DecimalFormat(this.config.getString(Configs.PATTERN_DECIMAL));
    }

    public void sendMessage(CommandSender sender, String message) {
        if (this.config.getBoolean(Configs.PREFIX_ENABLE)) {
            sender.sendMessage(MiniMessage.miniMessage().deserialize((Object)(this.message.prefix() + message)));
        } else {
            sender.sendMessage(MiniMessage.miniMessage().deserialize((Object)message));
        }
    }

    public boolean isEnable(CommandSender sender, Configs configs) {
        if (!this.config.getBoolean(configs)) {
            this.sendMessage(sender, this.message.getString(Messages.DISABLE_COMMAND));
            return false;
        }
        return true;
    }

    public boolean hasPermission(CommandSender sender, Configs configs) {
        if (!sender.hasPermission(this.config.getString(configs))) {
            this.sendMessage(sender, this.message.getString(Messages.NO_PERMISSION));
            return false;
        }
        return true;
    }

    public Player getPlayer(CommandSender sender) {
        return sender instanceof Player ? (Player)sender : null;
    }

    public boolean existPlayer(CommandSender sender) {
        Player player = this.getPlayer(sender);
        if (player == null) {
            this.sendMessage(sender, this.message.getString(Messages.NO_CONSOLE));
            return false;
        }
        return true;
    }

    public boolean existUser(CommandSender sender, String username) {
        if (!this.user.existsUser(username)) {
            this.sendMessage(sender, this.message.getString(Messages.NO_PLAYER_EXIST).replace("[PLAYER]", username));
            return false;
        }
        return true;
    }

    public boolean existUser(CommandSender sender, UUID uuid, String username) {
        if (!this.user.existsUser(uuid)) {
            this.sendMessage(sender, this.message.getString(Messages.NO_PLAYER_EXIST).replace("[PLAYER]", username));
            return false;
        }
        return true;
    }

    public UUID getUUID(CommandSender sender, String username) {
        try {
            return MojangUtils.getUUID(username);
        }
        catch (IOException | URISyntaxException e) {
            this.sendMessage(sender, this.message.getString(Messages.MOJANG_PROFILE_NOT_FOUND).replace("[USERNAME]", username));
            return null;
        }
    }

    public CompletableFuture<UUID> getUUIDAsync(CommandSender sender, String username) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return MojangUtils.getUUID(username);
            }
            catch (IOException | URISyntaxException e) {
                this.sendMessage(sender, this.message.getString(Messages.MOJANG_PROFILE_NOT_FOUND).replace("[USERNAME]", username));
                return null;
            }
        });
    }

    public List<String> tabCompletePlayers(CommandSender sender, String[] args) {
        ArrayList<String> tabComplete = new ArrayList<String>();
        String lastWord = args[args.length - 1];
        Player senderPlayer = sender instanceof Player ? (Player)sender : null;
        for (Player player : sender.getServer().getOnlinePlayers()) {
            String name = player.getName();
            if (senderPlayer != null && !senderPlayer.canSee(player) || !StringUtil.startsWithIgnoreCase((String)name, (String)lastWord)) continue;
            tabComplete.add(name);
        }
        tabComplete.sort(String.CASE_INSENSITIVE_ORDER);
        return tabComplete;
    }

    public List<String> tabCompletePlayers(CommandSender sender, String[] args, int length) {
        if (args.length == length) {
            return this.tabCompletePlayers(sender, args);
        }
        return Collections.emptyList();
    }

    public List<String> tabCompleteOfflinePlayers(CommandSender sender, String[] args) {
        ArrayList<String> tabComplete = new ArrayList<String>();
        String lastWord = args[args.length - 1];
        for (OfflinePlayer player : sender.getServer().getOfflinePlayers()) {
            String name = player.getName();
            assert (name != null);
            if (!StringUtil.startsWithIgnoreCase((String)name, (String)lastWord)) continue;
            tabComplete.add(name);
        }
        tabComplete.sort(String.CASE_INSENSITIVE_ORDER);
        return tabComplete;
    }

    public List<String> tabCompleteOfflinePlayers(CommandSender sender, String[] args, int length) {
        if (args.length == length) {
            return this.tabCompleteOfflinePlayers(sender, args);
        }
        return Collections.emptyList();
    }

    public List<String> tabComplete(List<String> list, String[] args) {
        return list.stream().filter(s -> StringUtil.startsWithIgnoreCase((String)s, (String)args[args.length - 1])).sorted().collect(Collectors.toList());
    }

    public List<String> tabComplete(List<String> list, String[] args, int length) {
        if (args.length == length) {
            return this.tabComplete(list, args);
        }
        return Collections.emptyList();
    }

    public static void register(CityBuild plugin) {
        CommandManager.addCommand((Plugin)plugin, "citybuildreload", new CityBuildReloadCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "enderchest", new EnderChestCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "setspawn", new SetSpawnCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "spawn", new SpawnCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "removewarp", new RemoveWarpCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "setwarp", new SetWarpCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "warp", new WarpCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "addhome", new AddHomeCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "home", new HomeCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "removehome", new RemoveHomeCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "workbench", new WorkbenchCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "anvil", new AnvilCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "trash", new TrashCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "feed", new FeedCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "heal", new HealCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "fly", new FlyCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "godmode", new GodModeCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "lobby", new LobbyCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "live", new LiveCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "day", new DayCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "night", new NightCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "sign", new SignCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "unsign", new UnSignCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "rename", new RenameCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "repair", new RepairCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "tp", new TpCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "tpa", new TpaCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "tpahere", new TpaHereCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "tpaaccept", new TpaAcceptCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "tpadeny", new TpaDenyCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "money", new MoneyCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "economy", new EconomyCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "gamemode", new GameModeCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "pay", new PayCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "sell", new SellCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "invsee", new InvseeCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "shopcategory", new ShopCategoryCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "shopitem", new ShopItemCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "shop", new ShopCommand(plugin));
        CommandManager.addCommand((Plugin)plugin, "bank", new BankCommand(plugin));
    }

    private static void addCommand(Plugin plugin, String name, TabExecutor executor) {
        PluginCommand command = plugin.getServer().getPluginCommand(name);
        if (command == null) {
            throw new RuntimeException("Couldn't find command: " + name);
        }
        command.setExecutor((CommandExecutor)executor);
        command.setTabCompleter((TabCompleter)executor);
    }
}

