/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.api.shop.category;

import de.murmelmeister.citybuild.CityBuild;
import de.murmelmeister.citybuild.api.shop.category.ShopCategory;
import de.murmelmeister.citybuild.files.ConfigFile;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.murmelapi.database.Database;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.slf4j.Logger;

public final class ShopCategoryProvider
implements ShopCategory {
    private static final String TABLE_NAME = "CB_ShopCategory";
    private final Database database;

    public ShopCategoryProvider(Database database) {
        this.database = database;
        this.createTable();
        Procedure.loadAll(database);
    }

    private void createTable() {
        this.database.createTable(TABLE_NAME, "ID UUID PRIMARY KEY, InternName TINYTEXT UNIQUE, DisplayName TINYTEXT, Icon TINYTEXT, Description MEDIUMTEXT");
    }

    @Override
    public boolean existsCategory(UUID id) {
        return id != null && this.database.existsCallable(Procedure.GET_DATA.getName(), id.toString());
    }

    @Override
    public boolean existsCategory(String internName) {
        return this.database.existsCallable(Procedure.GET_ID_BY_NAME.getName(), internName);
    }

    @Override
    public void addCategory(String internName, String displayName, Material icon) {
        this.addCategory(internName, displayName, icon, null);
    }

    @Override
    public void addCategory(String internName, String displayName, Material icon, String description) {
        this.addCategory(UUID.randomUUID(), internName, displayName, icon, description);
    }

    @Override
    public void addCategory(UUID id, String internName, String displayName, Material icon) {
        this.addCategory(id, internName, displayName, icon, null);
    }

    @Override
    public void addCategory(UUID id, String internName, String displayName, Material icon, String description) {
        this.database.updateCallable(Procedure.ADD_CATEGORY.getName(), id.toString(), internName, displayName, icon.name(), description);
    }

    @Override
    public void removeCategory(UUID id) {
        this.database.updateCallable(Procedure.REMOVE_CATEGORY.getName(), id.toString());
    }

    @Override
    public void updateDisplayName(UUID id, String displayName) {
        this.database.updateCallable(Procedure.UPDATE_DISPLAY_NAME.getName(), id.toString(), displayName);
    }

    @Override
    public void updateIcon(UUID id, Material icon) {
        this.database.updateCallable(Procedure.UPDATE_ICON.getName(), id.toString(), icon.name());
    }

    @Override
    public void updateDescription(UUID id, String description) {
        this.database.updateCallable(Procedure.UPDATE_DESCRIPTION.getName(), id.toString(), description);
    }

    @Override
    public List<UUID> getCategories() {
        return this.database.queryListCallable(Procedure.GET_ALL.getName(), new LinkedList(), resultSet -> UUID.fromString(resultSet.getString("ID")), new Object[0]);
    }

    @Override
    public List<String> getInternNames() {
        return this.database.queryListCallable(Procedure.GET_ALL.getName(), new LinkedList(), resultSet -> resultSet.getString("InternName"), new Object[0]);
    }

    @Override
    public UUID getCategoryId(String internName) {
        return this.database.queryCallable(Procedure.GET_ID_BY_NAME.getName(), null, resultSet -> {
            String id = resultSet.getString("ID");
            return id != null ? UUID.fromString(id) : null;
        }, internName);
    }

    @Override
    public String getInternName(UUID id) {
        return this.database.queryCallable(Procedure.GET_DATA.getName(), null, resultSet -> resultSet.getString("InternName"), id.toString());
    }

    @Override
    public String getDisplayName(UUID id) {
        return this.database.queryCallable(Procedure.GET_DATA.getName(), null, resultSet -> resultSet.getString("DisplayName"), id.toString());
    }

    @Override
    public Material getIcon(UUID id) {
        return this.database.queryCallable(Procedure.GET_DATA.getName(), null, resultSet -> {
            String icon = resultSet.getString("Icon");
            return icon != null ? Material.getMaterial((String)icon) : null;
        }, id.toString());
    }

    @Override
    public String getDescription(UUID id) {
        return this.database.queryCallable(Procedure.GET_DATA.getName(), null, resultSet -> resultSet.getString("Description"), id.toString());
    }

    @Override
    public String[] getLore(UUID id) {
        String description = this.getDescription(id);
        return description != null ? description.split("\n") : null;
    }

    @Override
    public ItemStack getItemStack(UUID id) {
        Material icon = this.getIcon(id);
        ItemStack itemStack = new ItemStack(icon);
        ItemMeta itemMeta = itemStack.getItemMeta();
        PersistentDataContainer container = itemMeta.getPersistentDataContainer();
        container.set(CityBuild.getKeyShopCategory(), PersistentDataType.BOOLEAN, (Object)true);
        itemMeta.displayName(MiniMessage.miniMessage().deserialize((Object)this.getDisplayName(id)));
        LinkedList<Component> lores = new LinkedList<Component>();
        String[] lore = this.getLore(id);
        if (lore != null) {
            for (String line : lore) {
                lores.add(MiniMessage.miniMessage().deserialize((Object)line));
            }
        }
        itemMeta.lore(lores);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    @Override
    public void importCSV(Logger logger, ConfigFile config) {
        String filePath = CityBuild.getMainPath() + config.getString(Configs.IMPORT_PATH) + config.getString(Configs.IMPORT_DATA_SHOP_CATEGORIES);
        File file = new File(filePath);
        logger.info("Importing categories from file: {}", (Object)file.getName());
        if (!file.exists()) {
            logger.error("File not found: {}", (Object)file.getName());
            return;
        }
        logger.info("Reading file: {}", (Object)file.getName());
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] data = line.split(",");
                if (data.length != 4) {
                    logger.error("Invalid line: {}", (Object)line);
                    continue;
                }
                String internName = data[0];
                if (this.existsCategory(internName)) {
                    logger.warn("ShopCategory with ID {} already exists, skipping...", (Object)internName);
                    continue;
                }
                String displayName = data[1];
                String icon = data[2];
                String description = data[3];
                Material material = Material.getMaterial((String)icon);
                if (material == null) {
                    logger.error("Invalid material: {}; Data: {}", (Object)icon, (Object)data);
                    continue;
                }
                UUID id = UUID.randomUUID();
                this.addCategory(id, internName, displayName, material, description);
            }
        }
        catch (IOException e) {
            logger.error("Error while reading file: {}", (Object)file.getName(), (Object)e);
        }
        logger.info("Importing categories from file: {} finished", (Object)file.getName());
    }

    private static enum Procedure {
        ADD_CATEGORY("CB_ShopCategory_AddCategory", "cid UUID, iname TINYTEXT, display TINYTEXT, mat TINYTEXT, des MEDIUMTEXT", "INSERT INTO [TABLE] VALUES (cid,iname,display,mat,des);"),
        REMOVE_CATEGORY("CB_ShopCategory_RemoveCategory", "cid UUID", "DELETE FROM [TABLE] WHERE ID=cid;"),
        GET_DATA_WITH_NAME("CB_ShopCategory_GetDataWithName", "cid UUID, iname TINYTEXT", "SELECT * FROM [TABLE] WHERE ID=cid AND InternName=iname;"),
        GET_DATA("CB_ShopCategory_GetData", "cid UUID", "SELECT * FROM [TABLE] WHERE ID=cid;"),
        GET_ID_BY_NAME("CB_ShopCategory_GetIdByName", "iname TINYTEXT", "SELECT ID FROM [TABLE] WHERE InternName=iname;"),
        GET_ALL("CB_ShopCategory_GetAll", "", "SELECT ID, InternName FROM [TABLE];"),
        UPDATE_DISPLAY_NAME("CB_ShopCategory_UpdateCategory", "cid UUID, display TINYTEXT", "UPDATE [TABLE] SET DisplayName=display WHERE ID=cid;"),
        UPDATE_ICON("CB_ShopCategory_UpdateCategory", "cid UUID, mat TINYTEXT", "UPDATE [TABLE] SET Icon=mat WHERE ID=cid;"),
        UPDATE_DESCRIPTION("CB_ShopCategory_UpdateCategory", "cid UUID, des MEDIUMTEXT", "UPDATE [TABLE] SET Description=des WHERE ID=cid;");

        private static final Procedure[] VALUES;
        private final String name;
        private final String query;

        private Procedure(String name, String input, String query) {
            this.name = name;
            this.query = Database.getProcedureQuery(name, input, query);
        }

        public String getName() {
            return this.name;
        }

        public String getQuery() {
            return this.query.replace("[TABLE]", ShopCategoryProvider.TABLE_NAME);
        }

        private static void loadAll(Database database) {
            for (Procedure procedure : VALUES) {
                database.update(procedure.getQuery(), new Object[0]);
            }
        }

        static {
            VALUES = Procedure.values();
        }
    }
}

