/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.api.shop;

import de.murmelmeister.citybuild.api.economy.Economy;
import de.murmelmeister.citybuild.api.item.CustomItem;
import de.murmelmeister.citybuild.api.shop.category.ShopCategory;
import de.murmelmeister.citybuild.api.shop.item.ShopItem;
import de.murmelmeister.citybuild.files.ConfigFile;
import de.murmelmeister.citybuild.files.MessageFile;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import de.murmelmeister.murmelapi.menu.Menu;
import de.murmelmeister.murmelapi.menu.MultipleMenu;
import de.murmelmeister.murmelapi.user.User;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public final class ShopMenu
extends MultipleMenu<UUID> {
    private final User user;
    private final ConfigFile configFile;
    private final MessageFile messageFile;
    private final CustomItem customItems;
    private final ShopCategory shopCategory;
    private final ShopItem shopItem;
    private final Economy economy;

    public ShopMenu(User user, ConfigFile configFile, MessageFile messageFile, CustomItem customItems, ShopCategory category, ShopItem item, Economy economy) {
        super((Menu)null, true, category.getCategories());
        this.user = user;
        this.configFile = configFile;
        this.messageFile = messageFile;
        this.customItems = customItems;
        this.shopCategory = category;
        this.shopItem = item;
        this.economy = economy;
        this.setTitle(configFile.getString(Configs.SHOP_CATEGORY_TITLE));
        Material material = Material.getMaterial((String)configFile.getString(Configs.SHOP_CATEGORY_PLACEHOLDER));
        if (material != null) {
            this.setPlaceholder(material);
        }
    }

    @Override
    protected ItemStack convertToItemStack(UUID categoryId) {
        return this.shopCategory.getItemStack(categoryId);
    }

    @Override
    protected void handlePageClick(Player player, UUID categoryId, ClickType clickType) {
        if (this.shopItem.getCategoryItems(categoryId).isEmpty()) {
            player.closeInventory();
            this.sendMessage((CommandSender)player, this.messageFile.getString(Messages.SHOP_CATEGORY_ITEMS_DOES_NOT_EXIST));
            return;
        }
        new CategoryItemMenu((Menu)this, this.user, this.configFile, this.messageFile, this.customItems, this.shopCategory, this.shopItem, this.economy, categoryId).show(player);
    }

    public void sendMessage(CommandSender sender, String message) {
        if (this.configFile.getBoolean(Configs.PREFIX_ENABLE)) {
            sender.sendMessage(MiniMessage.miniMessage().deserialize((Object)(this.messageFile.prefix() + message)));
        } else {
            sender.sendMessage(MiniMessage.miniMessage().deserialize((Object)message));
        }
    }

    private static class CategoryItemMenu
    extends MultipleMenu<UUID> {
        private final User user;
        private final ConfigFile configFile;
        private final MessageFile messageFile;
        private final CustomItem customItems;
        private final ShopItem shopItem;
        private final Economy economy;

        public CategoryItemMenu(Menu parent, User user, ConfigFile configFile, MessageFile messageFile, CustomItem customItems, ShopCategory category, ShopItem shopItem, Economy economy, UUID categoryId) {
            super(parent, false, shopItem.getCategoryItems(categoryId));
            this.user = user;
            this.configFile = configFile;
            this.messageFile = messageFile;
            this.shopItem = shopItem;
            this.economy = economy;
            this.customItems = customItems;
            this.setTitle(configFile.getString(Configs.SHOP_ITEM_TITLE).replace("[CATEGORY]", category.getDisplayName(categoryId)));
            this.setPlaceholder(Material.getMaterial((String)configFile.getString(Configs.SHOP_ITEM_PLACEHOLDER)));
        }

        @Override
        protected ItemStack convertToItemStack(UUID itemId) {
            int userId = this.user.getId(this.getViewer().getUniqueId());
            return this.shopItem.getItemStack(this.configFile, this.messageFile, this.customItems, this.economy, userId, itemId);
        }

        @Override
        protected void handlePageClick(Player player, UUID itemId, ClickType clickType) {
            Material material = this.shopItem.getIcon(itemId);
            if (material == null) {
                return;
            }
            int maxStackSize = material.getMaxStackSize();
            int userId = this.user.getId(player.getUniqueId());
            double buy = this.shopItem.getBuyPrice(itemId);
            Component noMoneyMessage = MiniMessage.miniMessage().deserialize((Object)this.messageFile.getString(Messages.SHOP_ITEM_MONEY_NOT_ENOUGH));
            if (clickType.isLeftClick()) {
                if (!this.economy.hasEnoughMoney(userId, buy)) {
                    player.closeInventory();
                    player.sendMessage(noMoneyMessage);
                    return;
                }
                this.economy.removeMoney(userId, buy);
                player.getInventory().addItem(new ItemStack[]{new ItemStack(material, 1)});
            }
            if (maxStackSize != 1 && clickType.isRightClick()) {
                if (!this.economy.hasEnoughMoney(userId, buy * (double)maxStackSize)) {
                    player.closeInventory();
                    player.sendMessage(noMoneyMessage);
                    return;
                }
                this.economy.removeMoney(userId, buy * (double)maxStackSize);
                player.getInventory().addItem(new ItemStack[]{new ItemStack(material, maxStackSize)});
            }
        }
    }
}

