/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.api.nbt;

import de.murmelmeister.citybuild.api.nbt.NbtTag;
import de.murmelmeister.citybuild.api.nbt.NbtTagInt;
import de.murmelmeister.citybuild.api.nbt.NbtTagString;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class NbtCompound
extends NbtTag {
    private final Map<String, NbtTag> tags = new HashMap<String, NbtTag>();

    public void setTag(String key, NbtTag tag) {
        this.tags.put(key, tag);
    }

    public NbtTag getTag(String key) {
        return this.tags.get(key);
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        for (Map.Entry<String, NbtTag> entry : this.tags.entrySet()) {
            out.writeUTF(entry.getKey());
            entry.getValue().write(out);
        }
    }

    @Override
    public void read(DataInputStream in) throws IOException, EOFException {
        while (in.available() > 0) {
            NbtTag tag;
            String key = in.readUTF();
            if (key.equals("lastKnownName")) {
                tag = new NbtTagString("");
                ((NbtTagString)tag).read(in);
                this.tags.put(key, tag);
                continue;
            }
            if (!key.equals("Health")) continue;
            tag = new NbtTagInt(0);
            ((NbtTagInt)tag).read(in);
            this.tags.put(key, tag);
        }
    }
}

