/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.api.item;

import de.murmelmeister.citybuild.CityBuild;
import de.murmelmeister.citybuild.api.item.CustomItem;
import de.murmelmeister.murmelapi.database.Database;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public final class CustomItemProvider
implements CustomItem {
    private static final String TABLE_NAME = "CB_CustomItems";
    private final Database database;

    public CustomItemProvider(Database database) {
        this.database = database;
        this.createTable();
        Procedure.loadAll(database);
    }

    private void createTable() {
        this.database.createTable(TABLE_NAME, "ID UUID PRIMARY KEY, InternName TINYTEXT UNIQUE, DisplayName TINYTEXT, Material TINYTEXT, Description MEDIUMTEXT");
    }

    @Override
    public boolean existsItem(UUID id) {
        return id != null && this.database.existsCallable(Procedure.GET_DATA.getName(), id.toString());
    }

    @Override
    public void addItem(String internName, String displayName, Material material) {
        this.addItem(internName, displayName, material, null);
    }

    @Override
    public void addItem(String internName, String displayName, Material material, String description) {
        this.addItem(UUID.randomUUID(), internName, displayName, material, description);
    }

    @Override
    public void addItem(UUID id, String internName, String displayName, Material material) {
        this.addItem(id, internName, displayName, material, null);
    }

    @Override
    public void addItem(UUID id, String internName, String displayName, Material material, String description) {
        this.database.updateCallable(Procedure.ADD_ITEM.getName(), id.toString(), internName, displayName, material.name(), description);
    }

    @Override
    public void removeItem(UUID id) {
        this.database.updateCallable(Procedure.REMOVE_ITEM.getName(), id.toString());
    }

    @Override
    public void updateItem(UUID id, String displayName, String iconName, Material material, String description) {
        this.database.updateCallable(Procedure.UPDATE_ITEM.getName(), id.toString(), displayName, iconName, material.name(), description);
    }

    @Override
    public List<UUID> getCustomItemIds() {
        return this.database.queryListCallable(Procedure.GET_ALL.getName(), new LinkedList(), resultSet -> UUID.fromString(resultSet.getString("ID")), new Object[0]);
    }

    @Override
    public List<String> getInternNames() {
        return this.database.queryListCallable(Procedure.GET_ALL.getName(), new LinkedList(), resultSet -> resultSet.getString("InternName"), new Object[0]);
    }

    @Override
    public UUID getCustomItemId(String internName) {
        return this.database.queryCallable(Procedure.GET_ID_BY_NAME.getName(), null, resultSet -> {
            String id = resultSet.getString("ID");
            return id != null ? UUID.fromString(id) : null;
        }, internName);
    }

    @Override
    public String getInternName(UUID id) {
        return this.database.queryCallable(Procedure.GET_DATA.getName(), null, resultSet -> resultSet.getString("InternName"), id.toString());
    }

    @Override
    public Component getDisplayName(UUID id) {
        return this.database.queryCallable(Procedure.GET_DATA.getName(), null, resultSet -> MiniMessage.miniMessage().deserialize((Object)resultSet.getString("DisplayName")), id.toString());
    }

    @Override
    public Material getMaterial(UUID id) {
        return this.database.queryCallable(Procedure.GET_DATA.getName(), null, resultSet -> {
            String material = resultSet.getString("Material");
            return material != null ? Material.getMaterial((String)material) : null;
        }, id.toString());
    }

    @Override
    public String getDescription(UUID id) {
        return this.database.queryCallable(Procedure.GET_DATA.getName(), null, resultSet -> resultSet.getString("Description"), id.toString());
    }

    @Override
    public String[] getLore(UUID id) {
        String description = this.getDescription(id);
        return description != null ? description.split("\n") : null;
    }

    @Override
    public ItemStack getItemStack(UUID id) {
        Material material = this.getMaterial(id);
        ItemStack itemStack = new ItemStack(material);
        ItemMeta itemMeta = itemStack.getItemMeta();
        PersistentDataContainer container = itemMeta.getPersistentDataContainer();
        container.set(CityBuild.getKeyCustomItems(), PersistentDataType.BOOLEAN, (Object)true);
        itemMeta.displayName(this.getDisplayName(id));
        LinkedList<Component> lores = new LinkedList<Component>();
        String[] lore = this.getLore(id);
        if (lore != null) {
            for (String line : lore) {
                lores.add(MiniMessage.miniMessage().deserialize((Object)line));
            }
        }
        itemMeta.lore(lores);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    @Override
    public void addDefaultMaterials() {
        for (Material material : Material.values()) {
            UUID id;
            if (material.isAir() || !material.isItem() || this.existsItem(id = UUID.randomUUID())) continue;
            String displayName = new ItemStack(material).getI18NDisplayName();
            this.addItem(id, material.name().toLowerCase(), displayName, material);
        }
    }

    private static enum Procedure {
        ADD_ITEM("CB_CustomItems_AddItem", "cid UUID, iname TINYTEXT, display TINYTEXT, mat TINYTEXT, des MEDIUMTEXT", "INSERT INTO [TABLE] VALUES (cid,iname,display,mat,des);"),
        REMOVE_ITEM("CB_CustomItems_RemoveItem", "cid UUID", "DELETE FROM [TABLE] WHERE ID=cid;"),
        GET_DATA("CB_CustomItems_GetData", "cid UUID", "SELECT * FROM [TABLE] WHERE ID=cid;"),
        GET_ID_BY_NAME("CB_CustomItems_GetIdByName", "iname TINYTEXT", "SELECT ID FROM [TABLE] WHERE InternName=iname;"),
        GET_ALL("CB_CustomItems_GetAll", "", "SELECT ID, InternName FROM [TABLE];"),
        UPDATE_ITEM("CB_CustomItems_UpdateItem", "cid UUID, display TINYTEXT, iname TINYTEXT, mat TINYTEXT, des MEDIUMTEXT", "UPDATE [TABLE] SET DisplayName=display, IconName=iname, Material=mat, Description=des WHERE ID=cid;");

        private static final Procedure[] VALUES;
        private final String name;
        private final String query;

        private Procedure(String name, String input, String query) {
            this.name = name;
            this.query = Database.getProcedureQuery(name, input, query);
        }

        public String getName() {
            return this.name;
        }

        public String getQuery() {
            return this.query.replace("[TABLE]", CustomItemProvider.TABLE_NAME);
        }

        public static void loadAll(Database database) {
            for (Procedure procedure : VALUES) {
                database.update(procedure.getQuery(), new Object[0]);
            }
        }

        static {
            VALUES = Procedure.values();
        }
    }
}

