/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.api.home;

import de.murmelmeister.citybuild.api.home.Home;
import de.murmelmeister.murmelapi.database.Database;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Server;

public final class HomeProvider
implements Home {
    private static final String TABLE_NAME = "CB_Home";
    private final Database database;

    public HomeProvider(Database database) {
        this.database = database;
        this.createTable();
        Procedure.loadAll(database);
    }

    private void createTable() {
        this.database.createTable(TABLE_NAME, "UserID INT, HomeName VARCHAR(100), PRIMARY KEY (UserID, HomeName), WorldName VARCHAR(100), WorldType VARCHAR(100), X DOUBLE, Y DOUBLE, Z DOUBLE, Yaw DOUBLE, Pitch DOUBLE");
    }

    @Override
    public boolean existsHome(int userId, String homeName) {
        return this.database.existsCallable(Procedure.HOME_GET.getName(), userId, homeName);
    }

    @Override
    public void addHome(int userId, String homeName, Location location) {
        String worldName = location.getWorld().getName();
        String environment = location.getWorld().getEnvironment().name();
        double x = (double)location.getBlockX() + 0.5;
        double y = (double)location.getBlockY() + 0.25;
        double z = (double)location.getBlockZ() + 0.5;
        double yaw = Math.round(location.getYaw() / 45.0f) * 45;
        double pitch = Math.round(location.getPitch() / 45.0f) * 45;
        this.database.updateCallable(Procedure.HOME_ADD.getName(), userId, homeName, worldName, environment, x, y, z, yaw, pitch);
    }

    @Override
    public void removeHome(int userId, String homeName) {
        this.database.updateCallable(Procedure.HOME_REMOVE.getName(), userId, homeName);
    }

    @Override
    public Location getHome(Server server, int userId, String homeName) {
        return this.database.queryCallable(Procedure.HOME_GET.getName(), null, resultSet -> {
            String worldName = resultSet.getString("WorldName");
            double x = resultSet.getDouble("X");
            double y = resultSet.getDouble("Y");
            double z = resultSet.getDouble("Z");
            double yaw = resultSet.getDouble("Yaw");
            double pitch = resultSet.getDouble("Pitch");
            return new Location(server.getWorld(worldName), x, y, z, (float)yaw, (float)pitch);
        }, userId, homeName);
    }

    @Override
    public List<String> getHomeNames(int userId) {
        return this.database.queryListCallable(Procedure.HOME_GET_ALL.getName(), new ArrayList(), resultSet -> resultSet.getString("HomeName"), userId);
    }

    private static enum Procedure {
        HOME_ADD("Home_Add", "uid INT, hname VARCHAR(100), wname VARCHAR(100), wtype VARCHAR(100), wx DOUBLE, wy DOUBLE, wz DOUBLE, wyaw DOUBLE, wp DOUBLE", "INSERT INTO [TABLE] VALUES (uid, hname, wname, wtype, wx, wy, wz, wyaw, wp);"),
        HOME_REMOVE("Home_Remove", "uid INT, hname VARCHAR(100)", "DELETE FROM [TABLE] WHERE UserID=uid AND HomeName=hname;"),
        HOME_GET("Home_Get", "uid INT, hname VARCHAR(100)", "SELECT * FROM [TABLE] WHERE UserID=uid AND HomeName=hname;"),
        HOME_GET_ALL("Home_GetAll", "uid INT", "SELECT * FROM [TABLE] WHERE UserID=uid;"),
        HOME_ALL("Home_All", "", "SELECT * FROM [TABLE];");

        private static final Procedure[] VALUES;
        private final String name;
        private final String query;

        private Procedure(String name, String input, String query) {
            this.name = name;
            this.query = Database.getProcedureQuery(name, input, query);
        }

        public String getName() {
            return this.name;
        }

        public String getQuery() {
            return this.query.replace("[TABLE]", HomeProvider.TABLE_NAME);
        }

        public static void loadAll(Database database) {
            for (Procedure procedure : VALUES) {
                database.update(procedure.getQuery(), new Object[0]);
            }
        }

        static {
            VALUES = Procedure.values();
        }
    }
}

