/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.api.enderchest;

import de.murmelmeister.citybuild.api.enderchest.EnderChestEditor;
import de.murmelmeister.citybuild.files.ConfigFile;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.murmelapi.menu.Menu;
import de.murmelmeister.murmelapi.menu.MultipleMenu;
import de.murmelmeister.murmelapi.menu.model.InventoryDrawer;
import de.murmelmeister.murmelapi.menu.model.MenuClickLocation;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public final class EnderChestMenu
extends MultipleMenu<Integer> {
    private final ConfigFile configFile;
    private final EnderChestEditor enderChestEditor;
    private final int userId;

    public EnderChestMenu(ConfigFile configFile, EnderChestEditor enderChestEditor, int userId) {
        super((Menu)null, true, enderChestEditor.getSlots(userId));
        this.configFile = configFile;
        this.enderChestEditor = enderChestEditor;
        this.userId = userId;
        this.setTitle(configFile.getString(Configs.ENDER_CHEST_TITLE));
        Material material = Material.getMaterial((String)configFile.getString(Configs.ENDER_CHEST_PLACEHOLDER));
        if (material != null) {
            this.setPlaceholder(material);
        }
    }

    @Override
    protected ItemStack convertToItemStack(Integer slot) {
        if (this.getViewer().hasPermission(this.configFile.getString(Configs.ENDER_CHEST_PERMISSION).replace("[SLOT]", String.valueOf(slot)))) {
            return this.enderChestEditor.getUnlockedIcon(slot);
        }
        return this.enderChestEditor.getLockedIcon(slot);
    }

    @Override
    protected void handlePageClick(Player player, Integer slot, ClickType clickType) {
        if (player.hasPermission(this.configFile.getString(Configs.ENDER_CHEST_PERMISSION).replace("[SLOT]", String.valueOf(slot)))) {
            new EnderChestSlotMenu(this, this.configFile, this.enderChestEditor, this.userId, slot).show(player);
        }
    }

    public static class EnderChestSlotMenu
    extends Menu {
        private final EnderChestEditor enderChestEditor;
        private final int userId;
        private final int slot;

        public EnderChestSlotMenu(Menu parent, ConfigFile configFile, EnderChestEditor enderChestEditor, int userId, int slot) {
            super(parent);
            this.userId = userId;
            this.slot = slot;
            this.enderChestEditor = enderChestEditor;
            this.setSize(configFile.getInt(Configs.ENDER_CHEST_SIZE));
            this.setTitle(configFile.getString(Configs.ENDER_CHEST_SLOT_TITLE).replace("[SLOT]", String.valueOf(slot)));
            this.setBackButton(this.getSize() - 1, parent);
        }

        @Override
        protected void handlePostDisplay(InventoryDrawer drawer) {
            ItemStack[] contents = this.enderChestEditor.getContents(this.userId, this.slot);
            for (int i = 0; i < Math.min(contents.length, this.getSize() - 9); ++i) {
                this.getInventory().setItem(i, contents[i]);
            }
        }

        @Override
        protected void handleMenuClose(Player player, Inventory inventory) {
            this.enderChestEditor.createOrUpdate(this.userId, this.slot, inventory, true);
        }

        @Override
        protected boolean isActionAllowed(MenuClickLocation location, int slot, ItemStack clicked, ItemStack cursor) {
            return slot < this.getSize() - 9;
        }
    }
}

