/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.api.economy;

import de.murmelmeister.citybuild.api.economy.Economy;
import de.murmelmeister.murmelapi.database.Database;
import java.text.DecimalFormat;
import java.util.regex.Pattern;

public final class EconomyProvider
implements Economy {
    public static final Pattern MONEY_PATTERN = Pattern.compile("^\\d+(\\.\\d{1,2})?$");
    private static final String TABLE_NAME = "CB_Economy";
    private final Database database;

    public EconomyProvider(Database database) {
        this.database = database;
        this.createTable();
        Procedure.loadAll(database);
    }

    private void createTable() {
        this.database.createTable(TABLE_NAME, "UserID INT PRIMARY KEY, Money DOUBLE, BankMoney DOUBLE");
    }

    @Override
    public boolean existUser(int userId) {
        return this.database.existsCallable(Procedure.ECONOMY_GET_USER.getName(), userId);
    }

    @Override
    public void createUser(int userId, double money, double bankMoney) {
        this.database.updateCallable(Procedure.ECONOMY_CREATE_USER.getName(), userId, money, bankMoney);
    }

    @Override
    public void deleteUser(int userId) {
        this.database.updateCallable(Procedure.ECONOMY_DELETE_USER.getName(), userId);
    }

    @Override
    public double getMoney(int userId) {
        return this.database.queryCallable(Procedure.ECONOMY_GET_USER.getName(), 0.0, resultSet -> resultSet.getDouble("Money"), userId);
    }

    @Override
    public double getBankMoney(int userId) {
        return this.database.queryCallable(Procedure.ECONOMY_GET_USER.getName(), 0.0, resultSet -> resultSet.getDouble("BankMoney"), userId);
    }

    @Override
    public String getFormattedMoney(int userId, String pattern) {
        return new DecimalFormat(pattern).format(this.getMoney(userId));
    }

    @Override
    public String getFormattedBankMoney(int userId, String pattern) {
        return new DecimalFormat(pattern).format(this.getBankMoney(userId));
    }

    @Override
    public void setMoney(int userId, double amount) {
        this.database.updateCallable(Procedure.ECONOMY_UPDATE_MONEY.getName(), userId, amount);
    }

    @Override
    public void setBankMoney(int userId, double amount) {
        this.database.updateCallable(Procedure.ECONOMY_UPDATE_BANK.getName(), userId, amount);
    }

    @Override
    public void addMoney(int userId, double amount) {
        double current = this.getMoney(userId);
        this.setMoney(userId, current += amount);
    }

    @Override
    public void addBankMoney(int userId, double amount) {
        double current = this.getBankMoney(userId);
        this.setBankMoney(userId, current += amount);
    }

    @Override
    public void removeMoney(int userId, double amount) {
        double current = this.getMoney(userId);
        this.setMoney(userId, current -= amount);
    }

    @Override
    public void removeBankMoney(int userId, double amount) {
        double current = this.getBankMoney(userId);
        this.setBankMoney(userId, current -= amount);
    }

    @Override
    public void resetMoney(int userId, double money) {
        this.setMoney(userId, money);
    }

    @Override
    public void resetBankMoney(int userId, double money) {
        this.setBankMoney(userId, money);
    }

    @Override
    public boolean hasEnoughMoney(int userId, double money) {
        return money <= this.getMoney(userId);
    }

    @Override
    public boolean hasEnoughBankMoney(int userId, double money) {
        return money <= this.getBankMoney(userId);
    }

    @Override
    public void transferMoney(int userId, int targetId, double money) {
        this.removeMoney(userId, money);
        this.addMoney(targetId, money);
    }

    @Override
    public boolean checkAndTransferMoney(int userId, int targetId, double money) {
        if (this.hasEnoughMoney(userId, money)) {
            this.transferMoney(userId, targetId, money);
            return true;
        }
        return false;
    }

    @Override
    public boolean transferMoneyToBank(int userId, double money) {
        if (this.hasEnoughMoney(userId, money)) {
            this.removeMoney(userId, money);
            this.addBankMoney(userId, money);
            return true;
        }
        return false;
    }

    @Override
    public boolean transferBankMoneyToPlayer(int userId, double money) {
        if (this.hasEnoughBankMoney(userId, money)) {
            this.removeBankMoney(userId, money);
            this.addMoney(userId, money);
            return true;
        }
        return false;
    }

    private static enum Procedure {
        ECONOMY_CREATE_USER("CB_Economy_CreateUser", "uid INT, current DOUBLE, bank DOUBLE", "INSERT INTO [TABLE] VALUES (uid, current, bank);"),
        ECONOMY_DELETE_USER("CB_Economy_DeleteUser", "uid INT", "DELETE FROM [TABLE] WHERE UserID=uid;"),
        ECONOMY_UPDATE_MONEY("CB_Economy_Update_Money", "uid INT, current DOUBLE", "UPDATE [TABLE] SET Money=current WHERE UserID=uid;"),
        ECONOMY_UPDATE_BANK("CB_Economy_Update_BankMoney", "uid INT, bank DOUBLE", "UPDATE [TABLE] SET BankMoney=bank WHERE UserID=uid;"),
        ECONOMY_GET_USER("CB_Economy_GetUser", "uid INT", "SELECT * FROM [TABLE] WHERE UserID=uid;"),
        ECONOMY_GET_ALL("CB_Economy_GetAll", "", "SELECT * FROM [TABLE];"),
        ECONOMY_UPDATE_ALL("CB_Economy_UpdateAll", "uid INT, current DOUBLE, bank DOUBLE", "UPDATE [TABLE] SET Money=current, BankMoney=bank WHERE UserID=uid;");

        private static final Procedure[] VALUES;
        private final String name;
        private final String query;

        private Procedure(String name, String input, String query) {
            this.name = name;
            this.query = Database.getProcedureQuery(name, input, query);
        }

        public String getName() {
            return this.name;
        }

        public String getQuery() {
            return this.query.replace("[TABLE]", EconomyProvider.TABLE_NAME);
        }

        public static void loadAll(Database database) {
            for (Procedure procedure : VALUES) {
                database.update(procedure.getQuery(), new Object[0]);
            }
        }

        static {
            VALUES = Procedure.values();
        }
    }
}

