/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.api;

import de.murmelmeister.citybuild.util.InventoryUtil;
import de.murmelmeister.murmelapi.database.Database;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class PlayerInventory {
    private static final String TABLE_NAME = "CB_UserInventory";
    private final Database database;

    public PlayerInventory(Database database) {
        this.database = database;
        this.createTable();
        Procedure.loadAll(database);
    }

    private void createTable() {
        this.database.createTable(TABLE_NAME, "UserID INT PRIMARY KEY, Content MEDIUMTEXT, StorageContent MEDIUMTEXT, ArmorContent MEDIUMTEXT, ExtraContent MEDIUMTEXT, EnderChestContent MEDIUMTEXT, EnderChestStorage MEDIUMTEXT");
    }

    public boolean existInventory(int userId) {
        return this.database.exists(Procedure.INVENTORY_GET.getName(), userId);
    }

    public void createOrUpdateInventory(int userId, Player player, boolean update) {
        String contents = InventoryUtil.saveItems(player.getInventory().getContents());
        String storageContents = InventoryUtil.saveItems(player.getInventory().getStorageContents());
        String armorContents = InventoryUtil.saveItems(player.getInventory().getArmorContents());
        String extraContents = InventoryUtil.saveItems(player.getInventory().getExtraContents());
        String enderChestContents = InventoryUtil.saveItems(player.getEnderChest().getContents());
        String enderChestStorage = InventoryUtil.saveItems(player.getEnderChest().getStorageContents());
        if (update) {
            this.database.updateCallable(Procedure.INVENTORY_UPDATE.getName(), userId, contents, storageContents, armorContents, extraContents, enderChestContents, enderChestStorage);
        } else {
            this.database.updateCallable(Procedure.INVENTORY_CREATE.getName(), userId, contents, storageContents, armorContents, extraContents, enderChestContents, enderChestStorage);
        }
    }

    public void deleteInventory(int userId) {
        this.database.updateCallable(Procedure.INVENTORY_DELETE.getName(), userId);
    }

    public void setInventory(int userId, Player player) {
        player.getInventory().setContents(this.getContents(userId));
        player.getInventory().setStorageContents(this.getStorageContents(userId));
        player.getInventory().setArmorContents(this.getArmorContents(userId));
        player.getInventory().setExtraContents(this.getExtraContents(userId));
        player.getEnderChest().setContents(this.getEnderChestContents(userId));
        player.getEnderChest().setStorageContents(this.getEnderChestStorage(userId));
    }

    public ItemStack[] getContents(int userId) {
        return InventoryUtil.loadItems(this.database.queryCallable(Procedure.INVENTORY_GET.getName(), null, resultSet -> resultSet.getString("Content"), userId));
    }

    public ItemStack[] getStorageContents(int userId) {
        return InventoryUtil.loadItems(this.database.queryCallable(Procedure.INVENTORY_GET.getName(), null, resultSet -> resultSet.getString("StorageContent"), userId));
    }

    public ItemStack[] getArmorContents(int userId) {
        return InventoryUtil.loadItems(this.database.queryCallable(Procedure.INVENTORY_GET.getName(), null, resultSet -> resultSet.getString("ArmorContent"), userId));
    }

    public ItemStack[] getExtraContents(int userId) {
        return InventoryUtil.loadItems(this.database.queryCallable(Procedure.INVENTORY_GET.getName(), null, resultSet -> resultSet.getString("ExtraContent"), userId));
    }

    public ItemStack[] getEnderChestContents(int userId) {
        return InventoryUtil.loadItems(this.database.queryCallable(Procedure.INVENTORY_GET.getName(), null, resultSet -> resultSet.getString("EnderChestContent"), userId));
    }

    public ItemStack[] getEnderChestStorage(int userId) {
        return InventoryUtil.loadItems(this.database.queryCallable(Procedure.INVENTORY_GET.getName(), null, resultSet -> resultSet.getString("EnderChestStorage"), userId));
    }

    private static enum Procedure {
        INVENTORY_CREATE("PlayerInventory_Create", "uid INT, cont MEDIUMTEXT, storage MEDIUMTEXT, armor MEDIUMTEXT, extra MEDIUMTEXT, eccont MEDIUMTEXT, ecstorage MEDIUMTEXT", "INSERT INTO [TABLE] VALUES (uid, cont, storage, armor, extra, eccont, ecstorage);"),
        INVENTORY_UPDATE("PlayerInventory_Update", "uid INT, cont MEDIUMTEXT, storage MEDIUMTEXT, armor MEDIUMTEXT, extra MEDIUMTEXT, eccont MEDIUMTEXT, ecstorage MEDIUMTEXT", "UPDATE [TABLE] SET Content=cont, StorageContent=storage, ArmorContent=armor, ExtraContent=extra, EnderChestContent=eccont, EnderChestStorage=ecstorage WHERE UserID=uid;"),
        INVENTORY_DELETE("PlayerInventory_Delete", "uid INT", "DELETE FROM [TABLE] WHERE UserID=uid;"),
        INVENTORY_GET("PlayerInventory_Get", "uid INT", "SELECT * FROM [TABLE] WHERE UserID=uid;");

        private static final Procedure[] VALUES;
        private final String name;
        private final String query;

        private Procedure(String name, String input, String query) {
            this.name = name;
            this.query = Database.getProcedureQuery(name, input, query);
        }

        public String getName() {
            return this.name;
        }

        public String getQuery() {
            return this.query.replace("[TABLE]", PlayerInventory.TABLE_NAME);
        }

        private static void loadAll(Database database) {
            for (Procedure procedure : VALUES) {
                database.update(procedure.getQuery(), new Object[0]);
            }
        }

        static {
            VALUES = Procedure.values();
        }
    }
}

