/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.api;

import de.murmelmeister.citybuild.CityBuild;
import de.murmelmeister.citybuild.util.FileUtil;
import de.murmelmeister.murmelapi.database.Database;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.slf4j.Logger;

public class Locations {
    private static final String TABLE_NAME = "CB_Locations";
    private final Database database;
    private final Logger logger;
    private final Server server;
    private File file;
    private YamlConfiguration config;
    private List<String> locationList;

    public Locations(Database database, Logger logger, Server server) {
        this.database = database;
        this.logger = logger;
        this.server = server;
        this.createTable();
        Procedure.loadAll(database);
    }

    private void createTable() {
        this.database.createTable(TABLE_NAME, "LocationID VARCHAR(100) PRIMARY KEY, WorldName VARCHAR(100), WorldType VARCHAR(100), X DOUBLE, Y DOUBLE, Z DOUBLE, Yaw DOUBLE, Pitch DOUBLE");
    }

    public void reloadFile() {
        this.create();
    }

    private void create() {
        this.file = FileUtil.createFile(this.logger, CityBuild.getMainPath(), "locations.yml");
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    private void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setLocation(Location location, String name) {
        String path = "Locations." + name;
        String worldName = location.getWorld().getName();
        String environment = location.getWorld().getEnvironment().name();
        double x = (double)location.getBlockX() + 0.5;
        double y = (double)location.getBlockY() + 0.25;
        double z = (double)location.getBlockZ() + 0.5;
        double yaw = Math.round(location.getYaw() / 45.0f) * 45;
        double pitch = Math.round(location.getPitch() / 45.0f) * 45;
        this.create();
        this.locationList = this.getLocationList();
        if (!this.locationList.contains(name)) {
            this.locationList.add(name);
            this.set("LocationList", this.locationList);
        }
        this.set(path + ".Name", name);
        this.set(path + ".WorldName", worldName);
        this.set(path + ".Environment", environment);
        this.set(path + ".X", x);
        this.set(path + ".Y", y);
        this.set(path + ".Z", z);
        this.set(path + ".Yaw", yaw);
        this.set(path + ".Pitch", pitch);
        this.save();
    }

    public void setSpawn(Location location) {
        this.setLocation(location, "Spawn");
    }

    public void removeLocation(String name) {
        this.create();
        this.locationList = this.getLocationList();
        this.locationList.remove(name);
        this.set("LocationList", this.locationList);
        this.set("Locations." + name, null);
        this.save();
    }

    public void removeSpawn() {
        this.removeLocation("Spawn");
    }

    public Location getLocation(String name) {
        this.create();
        String path = "Locations." + name;
        String worldName = this.getString(path + ".WorldName");
        double x = this.getDouble(path + ".X");
        double y = this.getDouble(path + ".Y");
        double z = this.getDouble(path + ".Z");
        double yaw = this.getDouble(path + ".Yaw");
        double pitch = this.getDouble(path + ".Pitch");
        World world = this.server.getWorld(worldName);
        return new Location(world, x, y, z, (float)yaw, (float)pitch);
    }

    public Location getSpawn() {
        return this.getLocation("Spawn");
    }

    public boolean isLocationExist(String name) {
        this.create();
        return this.config.get("Locations." + name) != null;
    }

    public boolean isSpawnExist() {
        return this.isLocationExist("Spawn");
    }

    private void set(String path, Object value) {
        this.config.set(path, value);
    }

    private String getString(String path) {
        return this.config.getString(path);
    }

    private double getDouble(String path) {
        return this.config.getDouble(path);
    }

    public List<String> getLocationList() {
        this.locationList = new ArrayList<String>();
        this.create();
        if (this.config.contains("LocationList")) {
            this.locationList = this.config.getStringList("LocationList");
        }
        return this.locationList;
    }

    private static enum Procedure {
        LOCATION_ADD("Location_Add", "lid VARCHAR(100), wname VARCHAR(100), wtype VARCHAR(100), wx DOUBLE, wy DOUBLE, wz DOUBLE, wyaw DOUBLE, wp DOUBLE", "INSERT INTO [TABLE] VALUES (lid, wname, wtype, wx, wy, wz, wyaw, wp);"),
        LOCATION_REMOVE("Location_Remove", "lid VARCHAR(100)", "DELETE FROM [TABLE] WHERE LocationID=lid;"),
        LOCATION_GET("Location_Get", "lid VARCHAR(100)", "SELECT * FROM [TABLE] WHERE LocationID=lid;"),
        LOCATION_GET_ALL("Location_GetAll", "", "SELECT * FROM [TABLE];");

        private static final Procedure[] VALUES;
        private final String name;
        private final String query;

        private Procedure(String name, String input, String query) {
            this.name = name;
            this.query = Database.getProcedureQuery(name, input, query);
        }

        public String getName() {
            return this.name;
        }

        public String getQuery() {
            return this.query.replace("[TABLE]", Locations.TABLE_NAME);
        }

        private static void loadAll(Database database) {
            for (Procedure procedure : VALUES) {
                database.update(procedure.getQuery(), new Object[0]);
            }
        }

        static {
            VALUES = Procedure.values();
        }
    }
}

