/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.api;

import de.murmelmeister.citybuild.CityBuild;
import de.murmelmeister.citybuild.files.ConfigFile;
import de.murmelmeister.citybuild.util.FileUtil;
import de.murmelmeister.citybuild.util.config.Configs;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.UUID;
import org.bukkit.configuration.file.YamlConfiguration;
import org.slf4j.Logger;

public class Cooldown {
    private final Logger logger;
    private File file;
    private YamlConfiguration config;

    public Cooldown(Logger logger) {
        this.logger = logger;
    }

    private void create(UUID uuid) {
        this.file = FileUtil.createFile(this.logger, CityBuild.getMainPath() + "/Cooldown/", uuid.toString() + ".yml");
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void add(UUID uuid, String cooldownName, long time) {
        this.create(uuid);
        long duration = System.currentTimeMillis() + time;
        this.set("Cooldown." + cooldownName + ".Start", System.currentTimeMillis());
        this.set("Cooldown." + cooldownName + ".Duration", duration);
        this.save();
    }

    public void remove(UUID uuid, String cooldownName) {
        this.create(uuid);
        this.set("Cooldown." + cooldownName, null);
        this.save();
    }

    public boolean has(UUID uuid, String cooldownName) {
        this.create(uuid);
        return this.config.get("Cooldown." + cooldownName) != null;
    }

    public long getDuration(UUID uuid, String cooldownName) {
        this.create(uuid);
        return this.config.getLong("Cooldown." + cooldownName + ".Duration");
    }

    public String getDurationDate(ConfigFile configFile, UUID uuid, String cooldownName) {
        long duration = this.getDuration(uuid, cooldownName);
        return new SimpleDateFormat(configFile.getString(Configs.DATE_FORMAT_PATTERN), Locale.of(configFile.getString(Configs.DATE_FORMAT_LOCALE))).format(duration);
    }

    public String getStartDate(ConfigFile configFile, UUID uuid, String cooldownName) {
        long startTime = this.config.getLong("Cooldown." + cooldownName + ".Start");
        return new SimpleDateFormat(configFile.getString(Configs.DATE_FORMAT_PATTERN), Locale.of(configFile.getString(Configs.DATE_FORMAT_LOCALE))).format(startTime);
    }

    private void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void set(String path, Object value) {
        this.config.set(path, value);
    }
}

