/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild;

import de.murmelmeister.citybuild.api.Cooldown;
import de.murmelmeister.citybuild.api.Locations;
import de.murmelmeister.citybuild.api.PlayerInventory;
import de.murmelmeister.citybuild.api.economy.Economy;
import de.murmelmeister.citybuild.api.economy.EconomyProvider;
import de.murmelmeister.citybuild.api.enderchest.EnderChestEditor;
import de.murmelmeister.citybuild.api.home.Home;
import de.murmelmeister.citybuild.api.home.HomeProvider;
import de.murmelmeister.citybuild.api.item.CustomItem;
import de.murmelmeister.citybuild.api.item.CustomItemProvider;
import de.murmelmeister.citybuild.api.shop.category.ShopCategory;
import de.murmelmeister.citybuild.api.shop.category.ShopCategoryProvider;
import de.murmelmeister.citybuild.api.shop.item.ShopItem;
import de.murmelmeister.citybuild.api.shop.item.ShopItemProvider;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.files.ConfigFile;
import de.murmelmeister.citybuild.files.MessageFile;
import de.murmelmeister.citybuild.files.MySQL;
import de.murmelmeister.citybuild.listener.ListenerManager;
import de.murmelmeister.citybuild.util.ImportDataUtil;
import de.murmelmeister.citybuild.util.ListUtil;
import de.murmelmeister.citybuild.util.TablistUtil;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.scoreboard.TestScoreboard;
import de.murmelmeister.murmelapi.MurmelAPI;
import de.murmelmeister.murmelapi.MurmelPlugin;
import de.murmelmeister.murmelapi.database.Database;
import de.murmelmeister.murmelapi.user.User;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.slf4j.Logger;

public final class CityBuild
extends MurmelPlugin {
    private final Database database = MurmelAPI.getDatabase();
    private ListUtil listUtil;
    private MySQL mySQL;
    private ConfigFile config;
    private MessageFile message;
    private Cooldown cooldown;
    private Locations locations;
    private Home homes;
    private Economy economy;
    private PlayerInventory playerInventory;
    private CustomItem customItems;
    private ShopCategory shopCategory;
    private ShopItem shopItem;
    private EnderChestEditor enderChestEditor;
    private BukkitTask scoreboardTask;
    private BukkitTask tablistTask;
    private final Map<Player, TestScoreboard> playerTestScoreboard = new ConcurrentHashMap<Player, TestScoreboard>();
    private final Map<Player, TablistUtil> playerTablistUtil = new ConcurrentHashMap<Player, TablistUtil>();

    public void onLoad() {
        Logger logger = this.getSLF4JLogger();
        this.config = new ConfigFile(logger);
        ImportDataUtil.createDirectory(logger, CityBuild.getMainPath() + this.config.getString(Configs.IMPORT_PATH));
        this.mySQL = new MySQL(logger, this.config);
        this.mySQL.connect();
        this.listUtil = new ListUtil();
        this.playerInventory = new PlayerInventory(this.database);
        this.message = new MessageFile(logger);
        this.cooldown = new Cooldown(logger);
        this.locations = new Locations(this.database, logger, this.getServer());
        this.homes = new HomeProvider(this.database);
        this.economy = new EconomyProvider(this.database);
        this.customItems = new CustomItemProvider(this.database);
        this.shopCategory = new ShopCategoryProvider(this.database);
        this.shopItem = new ShopItemProvider(this.database);
        this.enderChestEditor = new EnderChestEditor(this.database, this.config);
    }

    public void onDisable() {
        this.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this);
        if (this.scoreboardTask != null && !this.scoreboardTask.isCancelled()) {
            this.scoreboardTask.cancel();
        }
        if (this.tablistTask != null && !this.tablistTask.isCancelled()) {
            this.tablistTask.cancel();
        }
        this.playerTestScoreboard.clear();
        this.playerTablistUtil.clear();
        this.mySQL.disconnect();
    }

    @Override
    public void onEnable() {
        super.onEnable();
        ListenerManager.register(this);
        CommandManager.register(this);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        this.scoreboardTask = this.getServer().getScheduler().runTaskTimer((Plugin)this, () -> {
            for (Player player : this.getServer().getOnlinePlayers()) {
                this.playerTestScoreboard.computeIfAbsent(player, user -> new TestScoreboard((Player)user, this)).run();
            }
        }, 0L, 40L);
        this.tablistTask = this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
            for (Player player : this.getServer().getOnlinePlayers()) {
                this.playerTablistUtil.computeIfAbsent(player, user -> new TablistUtil(player, this)).setScoreboardTabList();
            }
        }, 0L, 40L);
    }

    public static CityBuild getInstance() {
        return (CityBuild)CityBuild.getPlugin(CityBuild.class);
    }

    public static String getMainPath() {
        return "./plugins/" + CityBuild.class.getSimpleName();
    }

    public static NamespacedKey getKeyEnderChest() {
        return new NamespacedKey((Plugin)CityBuild.getInstance(), "ender_chest");
    }

    public static NamespacedKey getKeyShopCategory() {
        return new NamespacedKey((Plugin)CityBuild.getInstance(), "shop_category");
    }

    public static NamespacedKey getKeyShopItem() {
        return new NamespacedKey((Plugin)CityBuild.getInstance(), "shop_item");
    }

    public static NamespacedKey getKeyCustomItems() {
        return new NamespacedKey((Plugin)CityBuild.getInstance(), "custom_items");
    }

    public ListUtil getListUtil() {
        return this.listUtil;
    }

    public ConfigFile getConfigFile() {
        return this.config;
    }

    public MessageFile getMessageFile() {
        return this.message;
    }

    public Cooldown getCooldown() {
        return this.cooldown;
    }

    public Locations getLocations() {
        return this.locations;
    }

    public Home getHomes() {
        return this.homes;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public PlayerInventory getPlayerInventory() {
        return this.playerInventory;
    }

    public User getUser() {
        return MurmelAPI.getUser();
    }

    public CustomItem getCustomItems() {
        return this.customItems;
    }

    public ShopCategory getShopCategory() {
        return this.shopCategory;
    }

    public ShopItem getShopItem() {
        return this.shopItem;
    }

    public EnderChestEditor getEnderChestEditor() {
        return this.enderChestEditor;
    }
}

