/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.util.scoreboard;

import de.murmelmeister.citybuild.Main;
import de.murmelmeister.citybuild.util.scoreboard.EntryName;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public abstract class ScoreboardBuilder
implements Runnable {
    private final Scoreboard scoreboard;
    private final Objective objective;
    protected final Player player;
    protected final Main main;

    public ScoreboardBuilder(Player player, Main main) {
        this.player = player;
        this.main = main;
        if (player.getScoreboard().equals((Object)Bukkit.getScoreboardManager().getMainScoreboard())) {
            player.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
        }
        this.scoreboard = player.getScoreboard();
        if (this.scoreboard.getObjective("display") != null) {
            Objects.requireNonNull(this.scoreboard.getObjective("display")).unregister();
        }
        this.objective = this.scoreboard.registerNewObjective("display", Criteria.DUMMY, (Component)Component.text((String)"Default Scoreboard", (TextColor)NamedTextColor.DARK_PURPLE));
        this.objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        this.createScoreboard();
    }

    @Override
    public void run() {
        if (this.player.getScoreboard() != null && this.player.getScoreboard().getObjective("display") != null) {
            this.updateScoreboard();
        } else {
            this.createScoreboard();
        }
    }

    protected abstract void createScoreboard();

    protected abstract void updateScoreboard();

    protected void setDisplayName(Component displayName) {
        this.objective.displayName(displayName);
    }

    protected void setDisplayName(String displayName) {
        this.objective.setDisplayName(displayName);
    }

    protected void setScoreContent(String content, int score) {
        this.objective.getScore(content).setScore(score);
    }

    protected void removeScoreContent(String content) {
        this.scoreboard.resetScores(content);
    }

    protected void setScoreTeam(Component content, int score) {
        Team team = this.getTeamByScore(score);
        if (team == null) {
            return;
        }
        team.prefix(content);
        this.showScore(score);
    }

    protected void setScoreTeam(String content, int score) {
        Team team = this.getTeamByScore(score);
        if (team == null) {
            return;
        }
        team.setPrefix(content);
        this.showScore(score);
    }

    protected void removeScoreTeam(int score) {
        this.hideScore(score);
    }

    private EntryName getEntryNameByScore(int id) {
        for (EntryName name : EntryName.values()) {
            if (id != name.getEntry()) continue;
            return name;
        }
        return null;
    }

    private Team getTeamByScore(int id) {
        EntryName name = this.getEntryNameByScore(id);
        if (name == null) {
            return null;
        }
        Team team = this.scoreboard.getEntryTeam(name.getEntryName());
        if (team != null) {
            return team;
        }
        team = this.scoreboard.registerNewTeam(name.name());
        team.addEntry(name.getEntryName());
        return team;
    }

    private void showScore(int score) {
        EntryName name = this.getEntryNameByScore(score);
        if (name == null) {
            return;
        }
        if (this.objective.getScore(name.getEntryName()).isScoreSet()) {
            return;
        }
        this.objective.getScore(name.getEntryName()).setScore(score);
    }

    private void hideScore(int score) {
        EntryName name = this.getEntryNameByScore(score);
        if (name == null) {
            return;
        }
        if (!this.objective.getScore(name.getEntryName()).isScoreSet()) {
            return;
        }
        this.scoreboard.resetScores(name.getEntryName());
    }
}

