/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.listener.listeners;

import de.murmelmeister.citybuild.Main;
import de.murmelmeister.citybuild.listener.Listeners;
import de.murmelmeister.citybuild.util.HexColor;
import de.murmelmeister.citybuild.util.config.Messages;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class EnderChestListener
extends Listeners {
    public EnderChestListener(Main main) {
        super(main);
    }

    @EventHandler
    public void handleEnderChestClick(InventoryClickEvent event) {
        Player target;
        Player player = (Player)event.getWhoClicked();
        ItemStack currentItem = event.getCurrentItem();
        if (currentItem == null) {
            return;
        }
        if (!currentItem.hasItemMeta()) {
            return;
        }
        if (currentItem.getItemMeta().getDisplayName().equals(HexColor.format(this.message.getString(Messages.ENDER_CHEST_MATERIAL_LOCKED)))) {
            event.setCancelled(true);
            player.closeInventory();
        }
        if (event.getView().getTitle().equals(HexColor.format(this.message.getString(Messages.ENDER_CHEST_MENU_USE)))) {
            event.setCancelled(true);
            for (int i = 1; i < 10; ++i) {
                if (!currentItem.getItemMeta().getDisplayName().equals(HexColor.format(this.message.getString(Messages.ENDER_CHEST_MATERIAL_UNLOCKED).replace("[SLOT]", "" + i)))) continue;
                int size = this.enderChest.getInventorySize(player.getUniqueId(), i) == null ? 54 : Integer.parseInt(this.enderChest.getInventorySize(player.getUniqueId(), i));
                Inventory inventory = this.enderChest.loadInventory(player, i, HexColor.format("&dEnderChest - " + i), size);
                this.enderChest.setInventory(inventory);
                player.openInventory(this.enderChest.getInventory());
            }
        }
        if ((target = this.enderChest.getTarget()) == null) {
            OfflinePlayer offlineTarget = this.enderChest.getOfflineTarget();
            if (offlineTarget == null) {
                return;
            }
            if (offlineTarget.isOnline() || offlineTarget.hasPlayedBefore()) {
                if (event.getView().getTitle().equals(HexColor.format(this.message.getString(Messages.ENDER_CHEST_MENU_OTHER).replace("[PLAYER]", offlineTarget.getName())))) {
                    event.setCancelled(true);
                    for (int i = 1; i < 10; ++i) {
                        if (!currentItem.getItemMeta().getDisplayName().equals(HexColor.format(this.message.getString(Messages.ENDER_CHEST_MATERIAL_UNLOCKED).replace("[SLOT]", "" + i)))) continue;
                        int size = this.enderChest.getInventorySize(offlineTarget.getUniqueId(), i) == null ? 54 : Integer.parseInt(this.enderChest.getInventorySize(offlineTarget.getUniqueId(), i));
                        Inventory inventory = this.enderChest.loadInventory(offlineTarget.getUniqueId(), player.getServer(), i, HexColor.format("&dEnderChest - " + i + " - " + offlineTarget.getName()), size);
                        this.enderChest.setInventory(inventory);
                        player.openInventory(this.enderChest.getInventory());
                        event.setCancelled(true);
                    }
                }
            } else {
                return;
            }
            return;
        }
        if (event.getView().getTitle().equals(HexColor.format(this.message.getString(Messages.ENDER_CHEST_MENU_OTHER).replace("[PLAYER]", target.getName())))) {
            event.setCancelled(true);
            for (int i = 1; i < 10; ++i) {
                if (!currentItem.getItemMeta().getDisplayName().equals(HexColor.format(this.message.getString(Messages.ENDER_CHEST_MATERIAL_UNLOCKED).replace("[SLOT]", "" + i)))) continue;
                int size = this.enderChest.getInventorySize(target.getUniqueId(), i) == null ? 54 : Integer.parseInt(this.enderChest.getInventorySize(target.getUniqueId(), i));
                Inventory inventory = this.enderChest.loadInventory(target, i, HexColor.format("&dEnderChest - " + i + " - " + target.getName()), size);
                this.enderChest.setInventory(inventory);
                player.openInventory(this.enderChest.getInventory());
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void handleEnderChestClose(InventoryCloseEvent event) {
        for (int i = 1; i < 10; ++i) {
            Player target;
            String title = HexColor.format("&dEnderChest - " + i);
            if (event.getView().getTitle().equals(title)) {
                this.enderChest.saveInventory(event.getPlayer().getUniqueId(), this.enderChest.getInventory(), i, title);
            }
            if ((target = this.enderChest.getTarget()) == null) {
                OfflinePlayer offlinePlayer = this.enderChest.getOfflineTarget();
                if (offlinePlayer == null) {
                    return;
                }
                if (offlinePlayer.isOnline() || offlinePlayer.hasPlayedBefore()) {
                    if (event.getView().getTitle().equals(title + " - " + offlinePlayer.getName())) {
                        this.enderChest.saveInventory(offlinePlayer.getUniqueId(), this.enderChest.getInventory(), i, title);
                    }
                } else {
                    return;
                }
                return;
            }
            if (!event.getView().getTitle().equals(title + " - " + target.getName())) continue;
            this.enderChest.saveInventory(target.getUniqueId(), this.enderChest.getInventory(), i, title);
        }
    }
}

