/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.listener.listeners;

import de.murmelmeister.citybuild.Main;
import de.murmelmeister.citybuild.listener.Listeners;
import de.murmelmeister.citybuild.util.HexColor;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class ConnectListener
extends Listeners {
    public ConnectListener(Main main) {
        super(main);
    }

    @EventHandler
    public void handlePlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.config.getBoolean(Configs.EVENT_ENABLE_PLAYER_JOIN)) {
            if (player.canSee(player)) {
                if (this.config.getBoolean(Configs.PREFIX_ENABLE)) {
                    event.setJoinMessage(HexColor.format(this.message.prefix() + this.message.getString(Messages.EVENT_PLAYER_JOIN).replace("[PLAYER]", player.getName())));
                } else {
                    event.setJoinMessage(HexColor.format(this.message.getString(Messages.EVENT_PLAYER_JOIN).replace("[PLAYER]", player.getName())));
                }
            } else {
                event.setJoinMessage(null);
            }
        } else {
            event.setJoinMessage(null);
        }
        if (this.locations.isSpawnExist()) {
            if (this.config.getBoolean(Configs.EVENT_ENABLE_TELEPORT_TO_SPAWN)) {
                player.teleport(this.locations.getLocation("Spawn"));
            }
        } else {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.EVENT_SPAWN_NOT_EXIST).replace("[PREFIX]", this.message.prefix()));
        }
        this.homes.createUsername(player.getUniqueId(), player.getName());
        this.cooldown.setUsername(player.getUniqueId(), player.getName());
        this.economy.setUsername(player.getUniqueId(), player.getName());
        this.economy.createAccount(player.getUniqueId());
        for (int i = 1; i < 10; ++i) {
            this.enderChest.setAccess(player.getUniqueId(), i, player.hasPermission(this.config.getString(Configs.PERMISSION_ENDER_CHEST_SLOTS) + "." + i));
        }
        if (player.hasPermission(this.config.getString(Configs.PERMISSION_JOIN_FLY))) {
            player.setAllowFlight(true);
            player.setFlying(true);
            this.sendMessage((CommandSender)player, this.message.getString(Messages.EVENT_JOIN_AUTO_FLY));
        }
        if (player.hasPermission(this.config.getString(Configs.PERMISSION_JOIN_GOD_MODE))) {
            this.listUtil.getGodMode().add(player.getUniqueId());
            this.sendMessage((CommandSender)player, this.message.getString(Messages.EVENT_JOIN_AUTO_GOD_MODE));
        }
        if (this.config.getBoolean(Configs.EVENT_ENABLE_JOIN_MESSAGE)) {
            player.sendMessage(HexColor.format(this.message.getString(Messages.EVENT_JOIN_MESSAGE).replace("[PREFIX]", this.message.prefix()).replace("[PLAYER]", player.getName())));
        }
        if (this.config.getBoolean(Configs.EVENT_ENABLE_JOIN_TITLE)) {
            player.sendTitle(HexColor.format(this.message.getString(Messages.EVENT_JOIN_TITLE)).replace("[PREFIX]", this.message.prefix()).replace("[PLAYER]", player.getName()), HexColor.format(this.message.getString(Messages.EVENT_JOIN_SUB_TITLE).replace("[PREFIX]", this.message.prefix()).replace("[PLAYER]", player.getName())));
        }
    }

    @EventHandler
    public void handlePlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.config.getBoolean(Configs.EVENT_ENABLE_PLAYER_QUIT)) {
            if (player.canSee(player)) {
                if (this.config.getBoolean(Configs.PREFIX_ENABLE)) {
                    event.setQuitMessage(HexColor.format(this.message.prefix() + this.message.getString(Messages.EVENT_PLAYER_QUIT).replace("[PLAYER]", player.getName())));
                } else {
                    event.setQuitMessage(HexColor.format(this.message.getString(Messages.EVENT_PLAYER_QUIT).replace("[PLAYER]", player.getName())));
                }
            } else {
                event.setQuitMessage(null);
            }
        } else {
            event.setQuitMessage(null);
        }
        this.listUtil.getGodMode().remove(player.getUniqueId());
        this.listUtil.getLive().remove(player.getUniqueId());
    }
}

