/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.listener;

import de.murmelmeister.citybuild.CityBuild;
import de.murmelmeister.citybuild.Main;
import de.murmelmeister.citybuild.api.Cooldown;
import de.murmelmeister.citybuild.api.Economy;
import de.murmelmeister.citybuild.api.EnderChest;
import de.murmelmeister.citybuild.api.Homes;
import de.murmelmeister.citybuild.api.ItemValue;
import de.murmelmeister.citybuild.api.Locations;
import de.murmelmeister.citybuild.configs.Config;
import de.murmelmeister.citybuild.configs.Message;
import de.murmelmeister.citybuild.listener.listeners.ConnectListener;
import de.murmelmeister.citybuild.listener.listeners.EnderChestListener;
import de.murmelmeister.citybuild.listener.listeners.GodModeListener;
import de.murmelmeister.citybuild.util.HexColor;
import de.murmelmeister.citybuild.util.ListUtil;
import de.murmelmeister.citybuild.util.config.Configs;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class Listeners
implements Listener {
    public final Main main;
    public final CityBuild instance;
    public final ListUtil listUtil;
    public final Config config;
    public final Message message;
    public final Cooldown cooldown;
    public final Locations locations;
    public final Homes homes;
    public final Economy economy;
    public final ItemValue itemValue;
    public final EnderChest enderChest;

    public Listeners(Main main) {
        this.main = main;
        this.instance = main.getInstance();
        this.listUtil = main.getListUtil();
        this.config = main.getConfig();
        this.message = main.getMessage();
        this.cooldown = main.getCooldown();
        this.locations = main.getLocations();
        this.homes = main.getHomes();
        this.economy = main.getEconomy();
        this.itemValue = main.getItemValue();
        this.enderChest = main.getEnderChest();
    }

    public void register() {
        this.addListener(new GodModeListener(this.main));
        this.addListener(new ConnectListener(this.main));
        this.addListener(new EnderChestListener(this.main));
    }

    private void addListener(Listener listener) {
        this.instance.getServer().getPluginManager().registerEvents(listener, (Plugin)this.instance);
    }

    public void sendMessage(CommandSender sender, String message) {
        if (this.config.getBoolean(Configs.PREFIX_ENABLE)) {
            sender.sendMessage(HexColor.format(this.message.prefix() + message));
        } else {
            sender.sendMessage(HexColor.format(message));
        }
    }
}

