/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands.teleport;

import de.murmelmeister.citybuild.Main;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TpaHereCommand
extends CommandManager {
    public TpaHereCommand(Main main) {
        super(main);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_TPA_HERE)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_TPA_HERE)) {
            return true;
        }
        Player player = this.getPlayer(sender);
        if (!this.existPlayer(sender)) {
            return true;
        }
        if (args.length != 1) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
            return true;
        }
        Player target = player.getServer().getPlayer(args[0]);
        if (target == null) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.NO_PLAYER_EXIST).replace("[PLAYER]", args[0]));
            return true;
        }
        this.listUtil.getTpaHere().put(target.getUniqueId(), player.getUniqueId());
        this.sendMessage((CommandSender)target, this.message.getString(Messages.COMMAND_TPA_HERE_GET_REQUEST_FROM_PLAYER).replace("[PLAYER]", player.getName()).replace("[PREFIX]", this.message.prefix()));
        this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_TPA_HERE_SEND_REQUEST_TO_TARGET).replace("[PLAYER]", target.getName()));
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return this.tabCompletePlayers(sender, args, 1);
    }
}

